/*
 * Player Plugin for jQuery JavaScript Library
 * http://www.jplayer.org
 *
 * Copyright (c) 2009 - 2014 Happyworm Ltd
 * Licensed under the MIT license.
 * http://opensource.org/licenses/MIT
 *
 * Author: Mark J Panaghiston
 * Version: 2.9.2
 * Date: 14th December 2014
 */

/* Support for Zepto 1.0 compiled with optional data module.
 * For AMD or NODE/CommonJS support, you will need to manually switch the related 2 lines in the code below.
 * Search terms: "jQuery Switch" and "Zepto Switch"
 */

(function(b,l){"function"===typeof define&&define.amd?define(["jquery"],l):"object"===typeof exports?l(require("jquery")):b.jQuery?l(b.jQuery):l(b.Zepto)})(this,function(b,l){b.fn.dlePlayerVideo=function(a){var c="string"===typeof a,d=Array.prototype.slice.call(arguments,1),f=this;a=!c&&d.length?b.extend.apply(null,[!0,a].concat(d)):a;if(c&&"_"===a.charAt(0))return f;c?this.each(function(){var c=b(this).data("dlePlayerVideo"),e=c&&b.isFunction(c[a])?c[a].apply(c,d):c;if(e!==c&&e!==l)return f=e,!1}):
this.each(function(){var c=b(this).data("dlePlayerVideo");c?c.option(a||{}):b(this).data("dlePlayerVideo",new b.dlePlayerVideo(a,this))});return f};b.dlePlayerVideo=function(a,c){if(arguments.length){this.element=b(c);this.options=b.extend(!0,{},this.options,a);var d=this;this.element.bind("remove.dlePlayerVideo",function(){d.destroy()});this._init()}};"function"!==typeof b.fn.stop&&(b.fn.stop=function(){});b.dlePlayerVideo.emulateMethods="load play pause";b.dlePlayerVideo.emulateStatus="src readyState networkState currentTime duration paused ended playbackRate";
b.dlePlayerVideo.emulateOptions="muted volume";b.dlePlayerVideo.reservedEvent="ready flashreset resize repeat error warning";b.dlePlayerVideo.event={};b.each("ready setmedia flashreset resize repeat click error warning loadstart progress suspend abort emptied stalled play pause loadedmetadata loadeddata waiting playing canplay canplaythrough seeking seeked timeupdate ended ratechange durationchange volumechange".split(" "),function(){b.dlePlayerVideo.event[this]="dlePlayerVideo_"+this});b.dlePlayerVideo.htmlEvent=
"loadstart abort emptied stalled loadedmetadata canplay canplaythrough".split(" ");b.dlePlayerVideo.pause=function(){b.dlePlayerVideo.prototype.destroyRemoved();b.each(b.dlePlayerVideo.prototype.instances,function(a,b){b.data("dlePlayerVideo").status.srcSet&&b.dlePlayerVideo("pause")})};b.dlePlayerVideo.timeFormat={showHour:!1,showMin:!0,showSec:!0,padHour:!1,padMin:!0,padSec:!0,sepHour:":",sepMin:":",sepSec:""};var g=function(){this.init()};g.prototype={init:function(){this.options={timeFormat:b.dlePlayerVideo.timeFormat}},
time:function(a){var b=new Date(1E3*(a&&"number"===typeof a?a:0)),d=b.getUTCHours();a=this.options.timeFormat.showHour?b.getUTCMinutes():b.getUTCMinutes()+60*d;b=this.options.timeFormat.showMin?b.getUTCSeconds():b.getUTCSeconds()+60*a;d=this.options.timeFormat.padHour&&10>d?"0"+d:d;a=this.options.timeFormat.padMin&&10>a?"0"+a:a;b=this.options.timeFormat.padSec&&10>b?"0"+b:b;d=""+(this.options.timeFormat.showHour?d+this.options.timeFormat.sepHour:"");d+=this.options.timeFormat.showMin?a+this.options.timeFormat.sepMin:
"";return d+=this.options.timeFormat.showSec?b+this.options.timeFormat.sepSec:""}};var h=new g;b.dlePlayerVideo.convertTime=function(a){return h.time(a)};b.dlePlayerVideo.uaBrowser=function(a){a=a.toLowerCase();var b=/(opera)(?:.*version)?[ \/]([\w.]+)/,d=/(msie) ([\w.]+)/,f=/(mozilla)(?:.*? rv:([\w.]+))?/;a=/(webkit)[ \/]([\w.]+)/.exec(a)||b.exec(a)||d.exec(a)||0>a.indexOf("compatible")&&f.exec(a)||[];return{browser:a[1]||"",version:a[2]||"0"}};b.dlePlayerVideo.uaPlatform=function(a){var b=a.toLowerCase(),
d=/(android)/,f=/(mobile)/;a=/(ipad|iphone|ipod|android|blackberry|playbook|windows ce|webos)/.exec(b)||[];b=/(ipad|playbook)/.exec(b)||!f.exec(b)&&d.exec(b)||[];a[1]&&(a[1]=a[1].replace(/\s/g,"_"));return{platform:a[1]||"",tablet:b[1]||""}};b.dlePlayerVideo.browser={};b.dlePlayerVideo.platform={};var k=b.dlePlayerVideo.uaBrowser(navigator.userAgent);k.browser&&(b.dlePlayerVideo.browser[k.browser]=!0,b.dlePlayerVideo.browser.version=k.version);k=b.dlePlayerVideo.uaPlatform(navigator.userAgent);k.platform&&
(b.dlePlayerVideo.platform[k.platform]=!0,b.dlePlayerVideo.platform.mobile=!k.tablet,b.dlePlayerVideo.platform.tablet=!!k.tablet);b.dlePlayerVideo.getDocMode=function(){if(b.dlePlayerVideo.browser.msie)if(document.documentMode)var a=document.documentMode;else a=5,document.compatMode&&"CSS1Compat"===document.compatMode&&(a=7);return a};b.dlePlayerVideo.browser.documentMode=b.dlePlayerVideo.getDocMode();b.dlePlayerVideo.nativeFeatures={init:function(){var a=document,b=a.createElement("video"),d={w3c:"fullscreenEnabled fullscreenElement requestFullscreen exitFullscreen fullscreenchange fullscreenerror".split(" "),
moz:"mozFullScreenEnabled mozFullScreenElement mozRequestFullScreen mozCancelFullScreen mozfullscreenchange mozfullscreenerror".split(" "),webkit:" webkitCurrentFullScreenElement webkitRequestFullScreen webkitCancelFullScreen webkitfullscreenchange ".split(" "),webkitVideo:"webkitSupportsFullscreen webkitDisplayingFullscreen webkitEnterFullscreen webkitExitFullscreen  ".split(" "),ms:" msFullscreenElement msRequestFullscreen msExitFullscreen MSFullscreenChange MSFullscreenError".split(" ")},f=["w3c",
"moz","webkit","webkitVideo","ms"],e;this.fullscreen=b={support:{w3c:!!a[d.w3c[0]],moz:!!a[d.moz[0]],webkit:"function"===typeof a[d.webkit[3]],webkitVideo:"function"===typeof b[d.webkitVideo[2]],ms:"function"===typeof b[d.ms[2]]},used:{}};var g=0;for(e=f.length;g<e;g++){var k=f[g];if(b.support[k]){b.spec=k;b.used[k]=!0;break}}if(b.spec){var h=d[b.spec];b.api={fullscreenEnabled:!0,fullscreenElement:function(b){b=b?b:a;return b[h[1]]},requestFullscreen:function(a){return a[h[2]]()},exitFullscreen:function(b){b=
b?b:a;return b[h[3]]()}};b.event={fullscreenchange:h[4],fullscreenerror:h[5]}}else b.api={fullscreenEnabled:!1,fullscreenElement:function(){return null},requestFullscreen:function(){},exitFullscreen:function(){}},b.event={}}};b.dlePlayerVideo.nativeFeatures.init();b.dlePlayerVideo.focus=null;b.dlePlayerVideo.keyIgnoreElementNames="A INPUT TEXTAREA SELECT BUTTON";var e=function(a){var c=b.dlePlayerVideo.focus,d;c&&(b.each(b.dlePlayerVideo.keyIgnoreElementNames.split(/\s+/g),function(b,c){if(a.target.nodeName.toUpperCase()===
c.toUpperCase())return d=!0,!1}),d||b.each(c.options.keyBindings,function(d,e){if(e&&b.isFunction(e.fn)&&("number"===typeof e.key&&a.which===e.key||"string"===typeof e.key&&a.key===e.key))return a.preventDefault(),e.fn(c),!1}))};b.dlePlayerVideo.keys=function(a){b(document.documentElement).unbind("keydown.dlePlayerVideo");a&&b(document.documentElement).bind("keydown.dlePlayerVideo",e)};b.dlePlayerVideo.keys(!0);b.dlePlayerVideo.prototype={count:0,version:{script:"2.9.2",needFlash:"2.9.0",flash:"unknown"},
options:{swfPath:"js",solution:"html, flash",supplied:"mp3",auroraFormats:"wav",preload:"metadata",volume:.8,muted:!1,remainingDuration:!1,toggleDuration:!1,captureDuration:!0,playbackRate:1,defaultPlaybackRate:1,minPlaybackRate:.5,maxPlaybackRate:4,wmode:"opaque",backgroundColor:"#000000",cssSelectorAncestor:"#jp_video_container_1",cssSelector:{videoPlay:".mdtc-clnplrv-video-play",play:".mdtc-clnplrv-play",pause:".mdtc-clnplrv-pause",stop:".mdtc-clnplrv-stop",seekBar:".mdtc-clnplrv-seek-bar",playBar:".mdtc-clnplrv-play-bar",
mute:".mdtc-clnplrv-mute",unmute:".mdtc-clnplrv-unmute",volumeBar:".mdtc-clnplrv-volume-bar",volumeBarValue:".mdtc-clnplrv-volume-bar-value",volumeMax:".mdtc-clnplrv-volume-max",playbackRateBar:".mdtc-clnplrv-playback-rate-bar",playbackRateBarValue:".mdtc-clnplrv-playback-rate-bar-value",currentTime:".mdtc-clnplrv-current-time",duration:".mdtc-clnplrv-duration",title:".mdtc-clnplrv-title",fullScreen:".mdtc-clnplrv-full-screen",restoreScreen:".mdtc-clnplrv-restore-screen",repeat:".mdtc-clnplrv-repeat",
repeatOff:".mdtc-clnplrv-repeat-off",gui:".mdtc-clnplrv-gui",noSolution:".mdtc-clnplrv-no-solution"},stateClass:{playing:"mdtc-clnplrv-state-playing",seeking:"mdtc-clnplrv-state-seeking",muted:"mdtc-clnplrv-state-muted",looped:"mdtc-clnplrv-state-looped",fullScreen:"mdtc-clnplrv-state-full-screen",noVolume:"mdtc-clnplrv-state-no-volume"},useStateClassSkin:!1,autoBlur:!0,smoothPlayBar:!1,fullScreen:!1,fullWindow:!1,autohide:{restored:!1,full:!0,fadeIn:200,fadeOut:600,hold:1E3},loop:!1,repeat:function(a){a.dlePlayerVideo.options.loop?
b(this).unbind(".dlePlayerVideoRepeat").bind(b.dlePlayerVideo.event.ended+".dlePlayerVideo.dlePlayerVideoRepeat",function(){b(this).dlePlayerVideo("play")}):b(this).unbind(".dlePlayerVideoRepeat")},nativeVideoControls:{},noFullWindow:{msie:/msie [0-6]\./,ipad:/ipad.*?os [0-4]\./,iphone:/iphone/,ipod:/ipod/,android_pad:/android [0-3]\.(?!.*?mobile)/,android_phone:/(?=.*android)(?!.*chrome)(?=.*mobile)/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/},noVolume:{ipad:/ipad/,
iphone:/iphone/,ipod:/ipod/,android_pad:/android(?!.*?mobile)/,android_phone:/android.*?mobile/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/,playbook:/playbook/},timeFormat:{},keyEnabled:!1,audioFullScreen:!1,keyBindings:{play:{key:80,fn:function(a){a.status.paused?a.play():a.pause()}},fullScreen:{key:70,fn:function(a){(a.status.video||a.options.audioFullScreen)&&a._setOption("fullScreen",!a.options.fullScreen)}},muted:{key:77,fn:function(a){a._muted(!a.options.muted)}},
volumeUp:{key:190,fn:function(a){a.volume(a.options.volume+.1)}},volumeDown:{key:188,fn:function(a){a.volume(a.options.volume-.1)}},loop:{key:76,fn:function(a){a._loop(!a.options.loop)}}},verticalVolume:!1,verticalPlaybackRate:!1,globalVolume:!1,idPrefix:"jp_video_",noConflict:"jQuery",emulateHtml:!1,consoleAlerts:!0,errorAlerts:!1,warningAlerts:!1},optionsAudio:{size:{width:"0px",height:"0px",cssClass:""},sizeFull:{width:"0px",height:"0px",cssClass:""}},optionsVideo:{size:{width:"480px",height:"270px",
cssClass:"mdtc-clnplrv-video-270p"},sizeFull:{width:"100%",height:"100%",cssClass:"mdtc-clnplrv-video-full"}},instances:{},status:{src:"",media:{},paused:!0,format:{},formatType:"",waitForPlay:!0,waitForLoad:!0,srcSet:!1,video:!1,seekPercent:0,currentPercentRelative:0,currentPercentAbsolute:0,currentTime:0,duration:0,remaining:0,videoWidth:0,videoHeight:0,readyState:0,networkState:0,playbackRate:1,ended:0},internal:{ready:!1},solution:{html:!0,aurora:!0,flash:!0},format:{mp3:{codec:"audio/mpeg",flashCanPlay:!0,
media:"audio"},m4a:{codec:'audio/mp4; codecs="mp4a.40.2"',flashCanPlay:!0,media:"audio"},m3u8a:{codec:'application/vnd.apple.mpegurl; codecs="mp4a.40.2"',flashCanPlay:!1,media:"audio"},m3ua:{codec:"audio/mpegurl",flashCanPlay:!1,media:"audio"},oga:{codec:'audio/ogg; codecs="vorbis, opus"',flashCanPlay:!1,media:"audio"},flac:{codec:"audio/x-flac",flashCanPlay:!1,media:"audio"},wav:{codec:'audio/wav; codecs="1"',flashCanPlay:!1,media:"audio"},webma:{codec:'audio/webm; codecs="vorbis"',flashCanPlay:!1,
media:"audio"},fla:{codec:"audio/x-flv",flashCanPlay:!0,media:"audio"},rtmpa:{codec:'audio/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"audio"},m4v:{codec:'video/mp4; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!0,media:"video"},m3u8v:{codec:'application/vnd.apple.mpegurl; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!1,media:"video"},m3uv:{codec:"audio/mpegurl",flashCanPlay:!1,media:"video"},ogv:{codec:'video/ogg; codecs="theora, vorbis"',flashCanPlay:!1,media:"video"},webmv:{codec:'video/webm; codecs="vorbis, vp8"',
flashCanPlay:!1,media:"video"},flv:{codec:"video/x-flv",flashCanPlay:!0,media:"video"},rtmpv:{codec:'video/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"video"}},_init:function(){var a=this;this.element.empty();this.status=b.extend({},this.status);this.internal=b.extend({},this.internal);this.options.timeFormat=b.extend({},b.dlePlayerVideo.timeFormat,this.options.timeFormat);this.internal.cmdsIgnored=b.dlePlayerVideo.platform.ipad||b.dlePlayerVideo.platform.iphone||b.dlePlayerVideo.platform.ipod;this.internal.domNode=
this.element.get(0);this.options.keyEnabled&&!b.dlePlayerVideo.focus&&(b.dlePlayerVideo.focus=this);this.androidFix={setMedia:!1,play:!1,pause:!1,time:NaN};b.dlePlayerVideo.platform.android&&(this.options.preload="auto"!==this.options.preload?"metadata":"auto");this.formats=[];this.solutions=[];this.require={};this.htmlElement={};this.html={};this.html.audio={};this.html.video={};this.aurora={};this.aurora.formats=[];this.aurora.properties=[];this.flash={};this.css={};this.css.cs={};this.css.jq={};
this.ancestorJq=[];this.options.volume=this._limitValue(this.options.volume,0,1);b.each(this.options.supplied.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.formats,function(a,b){if(f===b)return e=!0,!1});e||a.formats.push(f)}});b.each(this.options.solution.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.solution[f]){var e=!1;b.each(a.solutions,function(a,b){if(f===b)return e=!0,!1});e||a.solutions.push(f)}});
b.each(this.options.auroraFormats.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.aurora.formats,function(a,b){if(f===b)return e=!0,!1});e||a.aurora.formats.push(f)}});this.internal.instance="jp_video_"+this.count;this.instances[this.internal.instance]=this.element;this.element.attr("id")||this.element.attr("id",this.options.idPrefix+"_jplayer_"+this.count);this.internal.self=b.extend({},{id:this.element.attr("id"),jq:this.element});this.internal.audio=
b.extend({},{id:this.options.idPrefix+"_audio_"+this.count,jq:l});this.internal.video=b.extend({},{id:this.options.idPrefix+"_video_"+this.count,jq:l});this.internal.flash=b.extend({},{id:this.options.idPrefix+"_flash_"+this.count,jq:l,swf:this.options.swfPath+(".swf"!==this.options.swfPath.toLowerCase().slice(-4)?(this.options.swfPath&&"/"!==this.options.swfPath.slice(-1)?"/":"")+"jquery.jplayer.swf":"")});this.internal.poster=b.extend({},{id:this.options.idPrefix+"_poster_"+this.count,jq:l});b.each(b.dlePlayerVideo.event,
function(b,d){a.options[b]!==l&&(a.element.bind(d+".dlePlayerVideo",a.options[b]),a.options[b]=l)});this.require.audio=!1;this.require.video=!1;b.each(this.formats,function(b,d){a.require[a.format[d].media]=!0});this.options=this.require.video?b.extend(!0,{},this.optionsVideo,this.options):b.extend(!0,{},this.optionsAudio,this.options);this._setSize();this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);
this.status.noVolume=this._uaBlocklist(this.options.noVolume);b.dlePlayerVideo.nativeFeatures.fullscreen.api.fullscreenEnabled&&this._fullscreenAddEventListeners();this._restrictNativeVideoControls();this.htmlElement.poster=document.createElement("img");this.htmlElement.poster.id=this.internal.poster.id;this.htmlElement.poster.onload=function(){a.status.video&&!a.status.waitForPlay||a.internal.poster.jq.show()};this.element.append(this.htmlElement.poster);this.internal.poster.jq=b("#"+this.internal.poster.id);
this.internal.poster.jq.css({width:this.status.width,height:this.status.height});this.internal.poster.jq.hide();this.internal.poster.jq.bind("click.dlePlayerVideo",function(){a._trigger(b.dlePlayerVideo.event.click)});this.html.audio.available=!1;this.require.audio&&(this.htmlElement.audio=document.createElement("audio"),this.htmlElement.audio.id=this.internal.audio.id,this.html.audio.available=!!this.htmlElement.audio.canPlayType&&this._testCanPlayType(this.htmlElement.audio));this.html.video.available=
!1;this.require.video&&(this.htmlElement.video=document.createElement("video"),this.htmlElement.video.id=this.internal.video.id,this.html.video.available=!!this.htmlElement.video.canPlayType&&this._testCanPlayType(this.htmlElement.video));this.flash.available=this._checkForFlash(10.1);this.html.canPlay={};this.aurora.canPlay={};this.flash.canPlay={};b.each(this.formats,function(d,c){a.html.canPlay[c]=a.html[a.format[c].media].available&&""!==a.htmlElement[a.format[c].media].canPlayType(a.format[c].codec);
a.aurora.canPlay[c]=-1<b.inArray(c,a.aurora.formats);a.flash.canPlay[c]=a.format[c].flashCanPlay&&a.flash.available});this.html.desired=!1;this.aurora.desired=!1;this.flash.desired=!1;b.each(this.solutions,function(c,d){if(0===c)a[d].desired=!0;else{var f=!1,e=!1;b.each(a.formats,function(b,c){a[a.solutions[0]].canPlay[c]&&("video"===a.format[c].media?e=!0:f=!0)});a[d].desired=a.require.audio&&!f||a.require.video&&!e}});this.html.support={};this.aurora.support={};this.flash.support={};b.each(this.formats,
function(b,c){a.html.support[c]=a.html.canPlay[c]&&a.html.desired;a.aurora.support[c]=a.aurora.canPlay[c]&&a.aurora.desired;a.flash.support[c]=a.flash.canPlay[c]&&a.flash.desired});this.html.used=!1;this.aurora.used=!1;this.flash.used=!1;b.each(this.solutions,function(c,d){b.each(a.formats,function(b,c){if(a[d].support[c])return a[d].used=!0,!1})});this._resetActive();this._resetGate();this._cssSelectorAncestor(this.options.cssSelectorAncestor);this.html.used||this.aurora.used||this.flash.used?this.css.jq.noSolution.length&&
this.css.jq.noSolution.hide():(this._error({type:b.dlePlayerVideo.error.NO_SOLUTION,context:"{solution:'"+this.options.solution+"', supplied:'"+this.options.supplied+"'}",message:b.dlePlayerVideo.errorMsg.NO_SOLUTION,hint:b.dlePlayerVideo.errorHint.NO_SOLUTION}),this.css.jq.noSolution.length&&this.css.jq.noSolution.show());if(this.flash.used){var c="jQuery="+encodeURI(this.options.noConflict)+"&id="+encodeURI(this.internal.self.id)+"&vol="+this.options.volume+"&muted="+this.options.muted;if(b.dlePlayerVideo.browser.msie&&
(9>Number(b.dlePlayerVideo.browser.version)||9>b.dlePlayerVideo.browser.documentMode)){c=['<param name="movie" value="'+this.internal.flash.swf+'" />','<param name="FlashVars" value="'+c+'" />','<param name="allowScriptAccess" value="always" />','<param name="bgcolor" value="'+this.options.backgroundColor+'" />','<param name="wmode" value="'+this.options.wmode+'" />'];var d=document.createElement('<object id="'+this.internal.flash.id+'" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="0" height="0" tabindex="-1"></object>');
for(var f=0;f<c.length;f++)d.appendChild(document.createElement(c[f]))}else f=function(a,b,c){var d=document.createElement("param");d.setAttribute("name",b);d.setAttribute("value",c);a.appendChild(d)},d=document.createElement("object"),d.setAttribute("id",this.internal.flash.id),d.setAttribute("name",this.internal.flash.id),d.setAttribute("data",this.internal.flash.swf),d.setAttribute("type","application/x-shockwave-flash"),d.setAttribute("width","1"),d.setAttribute("height","1"),d.setAttribute("tabindex",
"-1"),f(d,"flashvars",c),f(d,"allowscriptaccess","always"),f(d,"bgcolor",this.options.backgroundColor),f(d,"wmode",this.options.wmode);this.element.append(d);this.internal.flash.jq=b(d)}this.status.playbackRateEnabled=this.html.used&&!this.flash.used?this._testPlaybackRate("audio"):!1;this._updatePlaybackRate();this.html.used&&(this.html.audio.available&&(this._addHtmlEventListeners(this.htmlElement.audio,this.html.audio),this.element.append(this.htmlElement.audio),this.internal.audio.jq=b("#"+this.internal.audio.id)),
this.html.video.available&&(this._addHtmlEventListeners(this.htmlElement.video,this.html.video),this.element.append(this.htmlElement.video),this.internal.video.jq=b("#"+this.internal.video.id),this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):this.internal.video.jq.css({width:"0px",height:"0px"}),this.internal.video.jq.bind("click.dlePlayerVideo",function(){a._trigger(b.dlePlayerVideo.event.click)})));this.options.emulateHtml&&this._emulateHtmlBridge();
!this.html.used&&!this.aurora.used||this.flash.used||setTimeout(function(){a.internal.ready=!0;a.version.flash="n/a";a._trigger(b.dlePlayerVideo.event.repeat);a._trigger(b.dlePlayerVideo.event.ready)},100);this._updateNativeVideoControls();this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();b.dlePlayerVideo.prototype.count++},destroy:function(){this.clearMedia();this._removeUiClass();this.css.jq.currentTime.length&&this.css.jq.currentTime.text("");this.css.jq.duration.length&&this.css.jq.duration.text("");
b.each(this.css.jq,function(a,b){b.length&&b.unbind(".dlePlayerVideo")});this.internal.poster.jq.unbind(".dlePlayerVideo");this.internal.video.jq&&this.internal.video.jq.unbind(".dlePlayerVideo");this._fullscreenRemoveEventListeners();this===b.dlePlayerVideo.focus&&(b.dlePlayerVideo.focus=null);this.options.emulateHtml&&this._destroyHtmlBridge();this.element.removeData("dlePlayerVideo");this.element.unbind(".dlePlayerVideo");this.element.empty();delete this.instances[this.internal.instance]},destroyRemoved:function(){var a=
this;b.each(this.instances,function(b,d){a.element===d||d.data("dlePlayerVideo")||(d.dlePlayerVideo("destroy"),delete a.instances[b])})},enable:function(){},disable:function(){},_testCanPlayType:function(a){try{return a.canPlayType(this.format.mp3.codec),!0}catch(c){return!1}},_testPlaybackRate:function(a){a=document.createElement("string"===typeof a?a:"audio");try{return"playbackRate"in a?(a.playbackRate=.5,.5===a.playbackRate):!1}catch(c){return!1}},_uaBlocklist:function(a){var c=navigator.userAgent.toLowerCase(),
d=!1;b.each(a,function(a,b){if(b&&b.test(c))return d=!0,!1});return d},_restrictNativeVideoControls:function(){this.require.audio&&this.status.nativeVideoControls&&(this.status.nativeVideoControls=!1,this.status.noFullWindow=!0)},_updateNativeVideoControls:function(){this.html.video.available&&this.html.used&&(this.htmlElement.video.controls=this.status.nativeVideoControls,this._updateAutohide(),this.status.nativeVideoControls&&this.require.video?(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,
height:this.status.height})):this.status.waitForPlay&&this.status.video&&(this.internal.poster.jq.show(),this.internal.video.jq.css({width:"0px",height:"0px"})))},_addHtmlEventListeners:function(a,c){var d=this;a.preload=this.options.preload;a.muted=this.options.muted;a.volume=this.options.volume;this.status.playbackRateEnabled&&(a.defaultPlaybackRate=this.options.defaultPlaybackRate,a.playbackRate=this.options.playbackRate);a.addEventListener("progress",function(){c.gate&&(d.internal.cmdsIgnored&&
0<this.readyState&&(d.internal.cmdsIgnored=!1),d._getHtmlStatus(a),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.progress))},!1);a.addEventListener("loadeddata",function(){c.gate&&(d.androidFix.setMedia=!1,d.androidFix.play&&(d.androidFix.play=!1,d.play(d.androidFix.time)),d.androidFix.pause&&(d.androidFix.pause=!1,d.pause(d.androidFix.time)),d._trigger(b.dlePlayerVideo.event.loadeddata))},!1);a.addEventListener("timeupdate",function(){c.gate&&(d._getHtmlStatus(a),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.timeupdate))},
!1);a.addEventListener("durationchange",function(){c.gate&&(d._getHtmlStatus(a),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.durationchange))},!1);a.addEventListener("play",function(){c.gate&&(d._updateButtons(!0),d._html_checkWaitForPlay(),d._trigger(b.dlePlayerVideo.event.play))},!1);a.addEventListener("playing",function(){c.gate&&(d._updateButtons(!0),d._seeked(),d._trigger(b.dlePlayerVideo.event.playing))},!1);a.addEventListener("pause",function(){c.gate&&(d._updateButtons(!1),d._trigger(b.dlePlayerVideo.event.pause))},
!1);a.addEventListener("waiting",function(){c.gate&&(d._seeking(),d._trigger(b.dlePlayerVideo.event.waiting))},!1);a.addEventListener("seeking",function(){c.gate&&(d._seeking(),d._trigger(b.dlePlayerVideo.event.seeking))},!1);a.addEventListener("seeked",function(){c.gate&&(d._seeked(),d._trigger(b.dlePlayerVideo.event.seeked))},!1);a.addEventListener("volumechange",function(){c.gate&&(d.options.volume=a.volume,d.options.muted=a.muted,d._updateMute(),d._updateVolume(),d._trigger(b.dlePlayerVideo.event.volumechange))},
!1);a.addEventListener("ratechange",function(){c.gate&&(d.options.defaultPlaybackRate=a.defaultPlaybackRate,d.options.playbackRate=a.playbackRate,d._updatePlaybackRate(),d._trigger(b.dlePlayerVideo.event.ratechange))},!1);a.addEventListener("suspend",function(){c.gate&&(d._seeked(),d._trigger(b.dlePlayerVideo.event.suspend))},!1);a.addEventListener("ended",function(){c.gate&&(b.dlePlayerVideo.browser.webkit||(d.htmlElement.media.currentTime=0),d.htmlElement.media.pause(),d._updateButtons(!1),d._getHtmlStatus(a,
!0),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.ended))},!1);a.addEventListener("error",function(){c.gate&&(d._updateButtons(!1),d._seeked(),d.status.srcSet&&(clearTimeout(d.internal.htmlDlyCmdId),d.status.waitForLoad=!0,d.status.waitForPlay=!0,d.status.video&&!d.status.nativeVideoControls&&d.internal.video.jq.css({width:"0px",height:"0px"}),d._validString(d.status.media.poster)&&!d.status.nativeVideoControls&&d.internal.poster.jq.show(),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.show(),
d._error({type:b.dlePlayerVideo.error.URL,context:d.status.src,message:b.dlePlayerVideo.errorMsg.URL,hint:b.dlePlayerVideo.errorHint.URL})))},!1);b.each(b.dlePlayerVideo.htmlEvent,function(f,e){a.addEventListener(this,function(){c.gate&&d._trigger(b.dlePlayerVideo.event[e])},!1)})},_addAuroraEventListeners:function(a,c){var d=this;a.volume=100*this.options.volume;a.on("progress",function(){c.gate&&(d.internal.cmdsIgnored&&0<this.readyState&&(d.internal.cmdsIgnored=!1),d._getAuroraStatus(a),d._updateInterface(),
d._trigger(b.dlePlayerVideo.event.progress),0<a.duration&&d._trigger(b.dlePlayerVideo.event.timeupdate))},!1);a.on("ready",function(){c.gate&&d._trigger(b.dlePlayerVideo.event.loadeddata)},!1);a.on("duration",function(){c.gate&&(d._getAuroraStatus(a),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.durationchange))},!1);a.on("end",function(){c.gate&&(d._updateButtons(!1),d._getAuroraStatus(a,!0),d._updateInterface(),d._trigger(b.dlePlayerVideo.event.ended))},!1);a.on("error",function(){c.gate&&
(d._updateButtons(!1),d._seeked(),d.status.srcSet&&(d.status.waitForLoad=!0,d.status.waitForPlay=!0,d.status.video&&!d.status.nativeVideoControls&&d.internal.video.jq.css({width:"0px",height:"0px"}),d._validString(d.status.media.poster)&&!d.status.nativeVideoControls&&d.internal.poster.jq.show(),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.show(),d._error({type:b.dlePlayerVideo.error.URL,context:d.status.src,message:b.dlePlayerVideo.errorMsg.URL,hint:b.dlePlayerVideo.errorHint.URL})))},!1)},_getHtmlStatus:function(a,
b){isFinite(a.duration)&&(this.status.duration=a.duration);var c=a.currentTime;var f=0<this.status.duration?100*c/this.status.duration:0;if("object"===typeof a.seekable&&0<a.seekable.length){var e=0<this.status.duration?100*a.seekable.end(a.seekable.length-1)/this.status.duration:100;var g=0<this.status.duration?100*a.currentTime/a.seekable.end(a.seekable.length-1):0}else e=100,g=f;b&&(f=g=c=0);this.status.seekPercent=e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=
c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=a.videoHeight;this.status.readyState=a.readyState;this.status.networkState=a.networkState;this.status.playbackRate=a.playbackRate;this.status.ended=a.ended},_getAuroraStatus:function(a,b){this.status.duration=a.duration/1E3;var c=a.currentTime/1E3;var f=0<this.status.duration?100*c/this.status.duration:0;if(0<a.buffered){var e=0<this.status.duration?a.buffered*this.status.duration/
this.status.duration:100;var g=0<this.status.duration?c/(a.buffered*this.status.duration):0}else e=100,g=f;b&&(f=g=c=0);this.status.seekPercent=e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_resetStatus:function(){this.status=b.extend({},this.status,b.dlePlayerVideo.prototype.status)},
_trigger:function(a,c,d){a=b.Event(a);a.dlePlayerVideo={};a.dlePlayerVideo.version=b.extend({},this.version);a.dlePlayerVideo.options=b.extend(!0,{},this.options);a.dlePlayerVideo.status=b.extend(!0,{},this.status);a.dlePlayerVideo.html=b.extend(!0,{},this.html);a.dlePlayerVideo.aurora=b.extend(!0,{},this.aurora);a.dlePlayerVideo.flash=b.extend(!0,{},this.flash);c&&(a.dlePlayerVideo.error=b.extend({},c));d&&(a.dlePlayerVideo.warning=b.extend({},d));this.element.trigger(a)},dlePlayerVideoFlashEvent:function(a,
c){if(a===b.dlePlayerVideo.event.ready)if(!this.internal.ready)this.internal.ready=!0,this.internal.flash.jq.css({width:"0px",height:"0px"}),this.version.flash=c.version,this.version.needFlash!==this.version.flash&&this._error({type:b.dlePlayerVideo.error.VERSION,context:this.version.flash,message:b.dlePlayerVideo.errorMsg.VERSION+this.version.flash,hint:b.dlePlayerVideo.errorHint.VERSION}),this._trigger(b.dlePlayerVideo.event.repeat),this._trigger(a);else if(this.flash.gate){if(this.status.srcSet){var d=
this.status.currentTime,f=this.status.paused;this.setMedia(this.status.media);this.volumeWorker(this.options.volume);0<d&&(f?this.pause(d):this.play(d))}this._trigger(b.dlePlayerVideo.event.flashreset)}if(this.flash.gate)switch(a){case b.dlePlayerVideo.event.progress:this._getFlashStatus(c);this._updateInterface();this._trigger(a);break;case b.dlePlayerVideo.event.timeupdate:this._getFlashStatus(c);this._updateInterface();this._trigger(a);break;case b.dlePlayerVideo.event.play:this._seeked();this._updateButtons(!0);
this._trigger(a);break;case b.dlePlayerVideo.event.pause:this._updateButtons(!1);this._trigger(a);break;case b.dlePlayerVideo.event.ended:this._updateButtons(!1);this._trigger(a);break;case b.dlePlayerVideo.event.click:this._trigger(a);break;case b.dlePlayerVideo.event.error:this.status.waitForLoad=!0;this.status.waitForPlay=!0;this.status.video&&this.internal.flash.jq.css({width:"0px",height:"0px"});this._validString(this.status.media.poster)&&this.internal.poster.jq.show();this.css.jq.videoPlay.length&&
this.status.video&&this.css.jq.videoPlay.show();this.status.video?this._flash_setVideo(this.status.media):this._flash_setAudio(this.status.media);this._updateButtons(!1);this._error({type:b.dlePlayerVideo.error.URL,context:c.src,message:b.dlePlayerVideo.errorMsg.URL,hint:b.dlePlayerVideo.errorHint.URL});break;case b.dlePlayerVideo.event.seeking:this._seeking();this._trigger(a);break;case b.dlePlayerVideo.event.seeked:this._seeked();this._trigger(a);break;case b.dlePlayerVideo.event.ready:break;default:this._trigger(a)}return!1},
_getFlashStatus:function(a){this.status.seekPercent=a.seekPercent;this.status.currentPercentRelative=a.currentPercentRelative;this.status.currentPercentAbsolute=a.currentPercentAbsolute;this.status.currentTime=a.currentTime;this.status.duration=a.duration;this.status.remaining=a.duration-a.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=a.videoHeight;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_updateButtons:function(a){a===
l?a=!this.status.paused:this.status.paused=!a;a?this.addStateClass("playing"):this.removeStateClass("playing");!this.status.noFullWindow&&this.options.fullWindow?this.addStateClass("fullScreen"):this.removeStateClass("fullScreen");this.options.loop?this.addStateClass("looped"):this.removeStateClass("looped");this.css.jq.play.length&&this.css.jq.pause.length&&(a?(this.css.jq.play.hide(),this.css.jq.pause.show()):(this.css.jq.play.show(),this.css.jq.pause.hide()));this.css.jq.restoreScreen.length&&
this.css.jq.fullScreen.length&&(this.status.noFullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.hide()):this.options.fullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.show()):(this.css.jq.fullScreen.show(),this.css.jq.restoreScreen.hide()));this.css.jq.repeat.length&&this.css.jq.repeatOff.length&&(this.options.loop?(this.css.jq.repeat.hide(),this.css.jq.repeatOff.show()):(this.css.jq.repeat.show(),this.css.jq.repeatOff.hide()))},_updateInterface:function(){this.css.jq.seekBar.length&&
this.css.jq.seekBar.width(this.status.seekPercent+"%");this.css.jq.playBar.length&&(this.options.smoothPlayBar?this.css.jq.playBar.stop().animate({width:this.status.currentPercentAbsolute+"%"},250,"linear"):this.css.jq.playBar.width(this.status.currentPercentRelative+"%"));if(this.css.jq.currentTime.length){var a=this._convertTime(this.status.currentTime);a!==this.css.jq.currentTime.text()&&this.css.jq.currentTime.text(this._convertTime(this.status.currentTime))}a=this.status.duration;var b=this.status.remaining;
this.css.jq.duration.length&&("string"===typeof this.status.media.duration?a=this.status.media.duration:("number"===typeof this.status.media.duration&&(a=this.status.media.duration,b=a-this.status.currentTime),a=this.options.remainingDuration?(0<b?"-":"")+this._convertTime(b):this._convertTime(a)),a!==this.css.jq.duration.text()&&this.css.jq.duration.text(a))},_convertTime:g.prototype.time,_seeking:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.addClass("mdtc-clnplrv-seeking-bg");this.addStateClass("seeking")},
_seeked:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.removeClass("mdtc-clnplrv-seeking-bg");this.removeStateClass("seeking")},_resetGate:function(){this.html.audio.gate=!1;this.html.video.gate=!1;this.aurora.gate=!1;this.flash.gate=!1},_resetActive:function(){this.html.active=!1;this.aurora.active=!1;this.flash.active=!1},_escapeHtml:function(a){return a.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;").split('"').join("&quot;")},_qualifyURL:function(a){var b=
document.createElement("div");b.innerHTML='<a href="'+this._escapeHtml(a)+'">x</a>';return b.firstChild.href},_absoluteMediaUrls:function(a){var c=this;b.each(a,function(b,f){f&&c.format[b]&&"data:"!==f.substr(0,5)&&(a[b]=c._qualifyURL(f))});return a},addStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.addClass(this.options.stateClass[a])},removeStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.removeClass(this.options.stateClass[a])},setMedia:function(a){var c=this,d=!1,
f=this.status.media.poster!==a.poster;this._resetMedia();this._resetGate();this._resetActive();this.androidFix.setMedia=!1;this.androidFix.play=!1;this.androidFix.pause=!1;a=this._absoluteMediaUrls(a);b.each(this.formats,function(f,e){var g="video"===c.format[e].media;b.each(c.solutions,function(f,k){if(c[k].support[e]&&c._validString(a[e])){var h="html"===k,m="aurora"===k;g?(h?(c.html.video.gate=!0,c._html_setVideo(a),c.html.active=!0):(c.flash.gate=!0,c._flash_setVideo(a),c.flash.active=!0),c.css.jq.videoPlay.length&&
c.css.jq.videoPlay.show(),c.status.video=!0):(h?(c.html.audio.gate=!0,c._html_setAudio(a),c.html.active=!0,b.dlePlayerVideo.platform.android&&(c.androidFix.setMedia=!0)):m?(c.aurora.gate=!0,c._aurora_setAudio(a),c.aurora.active=!0):(c.flash.gate=!0,c._flash_setAudio(a),c.flash.active=!0),c.css.jq.videoPlay.length&&c.css.jq.videoPlay.hide(),c.status.video=!1);d=!0;return!1}});if(d)return!1});d?(this.status.nativeVideoControls&&this.html.video.gate||!this._validString(a.poster)||(f?this.htmlElement.poster.src=
a.poster:this.internal.poster.jq.show()),"string"===typeof a.title&&this.css.jq.title.length&&this.css.jq.title.html(a.title),this.status.srcSet=!0,this.status.media=b.extend({},a),this._updateButtons(!1),this._updateInterface(),this._trigger(b.dlePlayerVideo.event.setmedia)):this._error({type:b.dlePlayerVideo.error.NO_SUPPORT,context:"{supplied:'"+this.options.supplied+"'}",message:b.dlePlayerVideo.errorMsg.NO_SUPPORT,hint:b.dlePlayerVideo.errorHint.NO_SUPPORT})},_resetMedia:function(){this._resetStatus();
this._updateButtons(!1);this._updateInterface();this._seeked();this.internal.poster.jq.hide();clearTimeout(this.internal.htmlDlyCmdId);this.html.active?this._html_resetMedia():this.aurora.active?this._aurora_resetMedia():this.flash.active&&this._flash_resetMedia()},clearMedia:function(){this._resetMedia();this.html.active?this._html_clearMedia():this.aurora.active?this._aurora_clearMedia():this.flash.active&&this._flash_clearMedia();this._resetGate();this._resetActive()},load:function(){this.status.srcSet?
this.html.active?this._html_load():this.aurora.active?this._aurora_load():this.flash.active&&this._flash_load():this._urlNotSetError("load")},focus:function(){this.options.keyEnabled&&(b.dlePlayerVideo.focus=this)},play:function(a){"object"===typeof a&&this.options.useStateClassSkin&&!this.status.paused?this.pause(a):(a="number"===typeof a?a:NaN,this.status.srcSet?(this.focus(),this.html.active?this._html_play(a):this.aurora.active?this._aurora_play(a):this.flash.active&&this._flash_play(a)):this._urlNotSetError("play"))},
videoPlay:function(){this.play()},pause:function(a){a="number"===typeof a?a:NaN;this.status.srcSet?this.html.active?this._html_pause(a):this.aurora.active?this._aurora_pause(a):this.flash.active&&this._flash_pause(a):this._urlNotSetError("pause")},tellOthers:function(a,c){var d=this,f="function"===typeof c,e=Array.prototype.slice.call(arguments);"string"===typeof a&&(f&&e.splice(1,1),b.dlePlayerVideo.prototype.destroyRemoved(),b.each(this.instances,function(){d.element===this||f&&!c.call(this.data("dlePlayerVideo"),
d)||this.dlePlayerVideo.apply(this,e)}))},pauseOthers:function(a){this.tellOthers("pause",function(){return this.status.srcSet},a)},stop:function(){this.status.srcSet?this.html.active?this._html_pause(0):this.aurora.active?this._aurora_pause(0):this.flash.active&&this._flash_pause(0):this._urlNotSetError("stop")},playHead:function(a){a=this._limitValue(a,0,100);this.status.srcSet?this.html.active?this._html_playHead(a):this.aurora.active?this._aurora_playHead(a):this.flash.active&&this._flash_playHead(a):
this._urlNotSetError("playHead")},_muted:function(a){this.mutedWorker(a);this.options.globalVolume&&this.tellOthers("mutedWorker",function(){return this.options.globalVolume},a)},mutedWorker:function(a){this.options.muted=a;this.html.used&&this._html_setProperty("muted",a);this.aurora.used&&this._aurora_mute(a);this.flash.used&&this._flash_mute(a);this.html.video.gate||this.html.audio.gate||(this._updateMute(a),this._updateVolume(this.options.volume),this._trigger(b.dlePlayerVideo.event.volumechange))},
mute:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.muted?this._muted(!1):(a=a===l?!0:!!a,this._muted(a))},unmute:function(a){a=a===l?!0:!!a;this._muted(!a)},_updateMute:function(a){a===l&&(a=this.options.muted);a?this.addStateClass("muted"):this.removeStateClass("muted");this.css.jq.mute.length&&this.css.jq.unmute.length&&(this.status.noVolume?(this.css.jq.mute.hide(),this.css.jq.unmute.hide()):a?(this.css.jq.mute.hide(),this.css.jq.unmute.show()):(this.css.jq.mute.show(),
this.css.jq.unmute.hide()))},volume:function(a){this.volumeWorker(a);this.options.globalVolume&&this.tellOthers("volumeWorker",function(){return this.options.globalVolume},a)},volumeWorker:function(a){a=this._limitValue(a,0,1);this.options.volume=a;this.html.used&&this._html_setProperty("volume",a);this.aurora.used&&this._aurora_volume(a);this.flash.used&&this._flash_volume(a);this.html.video.gate||this.html.audio.gate||(this._updateVolume(a),this._trigger(b.dlePlayerVideo.event.volumechange))},volumeBar:function(a){if(this.css.jq.volumeBar.length){var c=
b(a.currentTarget),d=c.offset(),f=a.pageX-d.left,e=c.width();a=c.height()-a.pageY+d.top;c=c.height();this.options.verticalVolume?this.volume(a/c):this.volume(f/e)}this.options.muted&&this._muted(!1)},_updateVolume:function(a){a===l&&(a=this.options.volume);a=this.options.muted?0:a;this.status.noVolume?(this.addStateClass("noVolume"),this.css.jq.volumeBar.length&&this.css.jq.volumeBar.hide(),this.css.jq.volumeBarValue.length&&this.css.jq.volumeBarValue.hide(),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.hide()):
(this.removeStateClass("noVolume"),this.css.jq.volumeBar.length&&this.css.jq.volumeBar.show(),this.css.jq.volumeBarValue.length&&(this.css.jq.volumeBarValue.show(),this.css.jq.volumeBarValue[this.options.verticalVolume?"height":"width"](100*a+"%")),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.show())},volumeMax:function(){this.volume(1);this.options.muted&&this._muted(!1)},_cssSelectorAncestor:function(a){var c=this;this.options.cssSelectorAncestor=a;this._removeUiClass();this.ancestorJq=a?
b(a):[];a&&1!==this.ancestorJq.length&&this._warning({type:b.dlePlayerVideo.warning.CSS_SELECTOR_COUNT,context:a,message:b.dlePlayerVideo.warningMsg.CSS_SELECTOR_COUNT+this.ancestorJq.length+" found for cssSelectorAncestor.",hint:b.dlePlayerVideo.warningHint.CSS_SELECTOR_COUNT});this._addUiClass();b.each(this.options.cssSelector,function(a,b){c._cssSelector(a,b)});this._updateInterface();this._updateButtons();this._updateAutohide();this._updateVolume();this._updateMute()},_cssSelector:function(a,
c){var d=this;"string"===typeof c?b.dlePlayerVideo.prototype.options.cssSelector[a]?(this.css.jq[a]&&this.css.jq[a].length&&this.css.jq[a].unbind(".dlePlayerVideo"),this.options.cssSelector[a]=c,this.css.cs[a]=this.options.cssSelectorAncestor+" "+c,this.css.jq[a]=c?b(this.css.cs[a]):[],this.css.jq[a].length&&this[a]&&this.css.jq[a].bind("click.dlePlayerVideo",function(c){c.preventDefault();d[a](c);d.options.autoBlur?b(this).blur():b(this).focus()}),c&&1!==this.css.jq[a].length&&this._warning({type:b.dlePlayerVideo.warning.CSS_SELECTOR_COUNT,
context:this.css.cs[a],message:b.dlePlayerVideo.warningMsg.CSS_SELECTOR_COUNT+this.css.jq[a].length+" found for "+a+" method.",hint:b.dlePlayerVideo.warningHint.CSS_SELECTOR_COUNT})):this._warning({type:b.dlePlayerVideo.warning.CSS_SELECTOR_METHOD,context:a,message:b.dlePlayerVideo.warningMsg.CSS_SELECTOR_METHOD,hint:b.dlePlayerVideo.warningHint.CSS_SELECTOR_METHOD}):this._warning({type:b.dlePlayerVideo.warning.CSS_SELECTOR_STRING,context:c,message:b.dlePlayerVideo.warningMsg.CSS_SELECTOR_STRING,
hint:b.dlePlayerVideo.warningHint.CSS_SELECTOR_STRING})},duration:function(a){this.options.toggleDuration&&(this.options.captureDuration&&a.stopPropagation(),this._setOption("remainingDuration",!this.options.remainingDuration))},seekBar:function(a){if(this.css.jq.seekBar.length){var c=b(a.currentTarget),d=c.offset();a=a.pageX-d.left;c=c.width();this.playHead(100*a/c)}},playbackRate:function(a){this._setOption("playbackRate",a)},playbackRateBar:function(a){if(this.css.jq.playbackRateBar.length){var c=
b(a.currentTarget),d=c.offset(),f=a.pageX-d.left,e=c.width();a=c.height()-a.pageY+d.top;c=c.height();this.playbackRate((this.options.verticalPlaybackRate?a/c:f/e)*(this.options.maxPlaybackRate-this.options.minPlaybackRate)+this.options.minPlaybackRate)}},_updatePlaybackRate:function(){var a=(this.options.playbackRate-this.options.minPlaybackRate)/(this.options.maxPlaybackRate-this.options.minPlaybackRate);this.status.playbackRateEnabled?(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.show(),
this.css.jq.playbackRateBarValue.length&&(this.css.jq.playbackRateBarValue.show(),this.css.jq.playbackRateBarValue[this.options.verticalPlaybackRate?"height":"width"](100*a+"%"))):(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.hide(),this.css.jq.playbackRateBarValue.length&&this.css.jq.playbackRateBarValue.hide())},repeat:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.loop?this._loop(!1):this._loop(!0)},repeatOff:function(){this._loop(!1)},_loop:function(a){this.options.loop!==
a&&(this.options.loop=a,this._updateButtons(),this._trigger(b.dlePlayerVideo.event.repeat))},option:function(a,c){var d=a;if(0===arguments.length)return b.extend(!0,{},this.options);if("string"===typeof a){var f=a.split(".");if(c===l){d=b.extend(!0,{},this.options);for(var e=0;e<f.length;e++)if(d[f[e]]!==l)d=d[f[e]];else return this._warning({type:b.dlePlayerVideo.warning.OPTION_KEY,context:a,message:b.dlePlayerVideo.warningMsg.OPTION_KEY,hint:b.dlePlayerVideo.warningHint.OPTION_KEY}),l;return d}e=
d={};for(var g=0;g<f.length;g++)g<f.length-1?(e[f[g]]={},e=e[f[g]]):e[f[g]]=c}this._setOptions(d);return this},_setOptions:function(a){var c=this;b.each(a,function(a,b){c._setOption(a,b)});return this},_setOption:function(a,c){var d=this;switch(a){case "volume":this.volume(c);break;case "muted":this._muted(c);break;case "globalVolume":this.options[a]=c;break;case "cssSelectorAncestor":this._cssSelectorAncestor(c);break;case "cssSelector":b.each(c,function(a,b){d._cssSelector(a,b)});break;case "playbackRate":this.options[a]=
c=this._limitValue(c,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("playbackRate",c);this._updatePlaybackRate();break;case "defaultPlaybackRate":this.options[a]=c=this._limitValue(c,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("defaultPlaybackRate",c);this._updatePlaybackRate();break;case "minPlaybackRate":this.options[a]=c=this._limitValue(c,.1,this.options.maxPlaybackRate-.1);this._updatePlaybackRate();
break;case "maxPlaybackRate":this.options[a]=c=this._limitValue(c,this.options.minPlaybackRate+.1,16);this._updatePlaybackRate();break;case "fullScreen":if(this.options[a]!==c){var f=b.dlePlayerVideo.nativeFeatures.fullscreen.used.webkitVideo;if(!f||f&&!this.status.waitForPlay)f||(this.options[a]=c),c?this._requestFullscreen():this._exitFullscreen(),f||this._setOption("fullWindow",c)}break;case "fullWindow":this.options[a]!==c&&(this._removeUiClass(),this.options[a]=c,this._refreshSize());break;case "size":this.options.fullWindow||
this.options[a].cssClass===c.cssClass||this._removeUiClass();this.options[a]=b.extend({},this.options[a],c);this._refreshSize();break;case "sizeFull":this.options.fullWindow&&this.options[a].cssClass!==c.cssClass&&this._removeUiClass();this.options[a]=b.extend({},this.options[a],c);this._refreshSize();break;case "autohide":this.options[a]=b.extend({},this.options[a],c);this._updateAutohide();break;case "loop":this._loop(c);break;case "remainingDuration":this.options[a]=c;this._updateInterface();break;
case "toggleDuration":this.options[a]=c;break;case "nativeVideoControls":this.options[a]=b.extend({},this.options[a],c);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this._restrictNativeVideoControls();this._updateNativeVideoControls();break;case "noFullWindow":this.options[a]=b.extend({},this.options[a],c);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);
this._restrictNativeVideoControls();this._updateButtons();break;case "noVolume":this.options[a]=b.extend({},this.options[a],c);this.status.noVolume=this._uaBlocklist(this.options.noVolume);this._updateVolume();this._updateMute();break;case "emulateHtml":this.options[a]!==c&&((this.options[a]=c)?this._emulateHtmlBridge():this._destroyHtmlBridge());break;case "timeFormat":this.options[a]=b.extend({},this.options[a],c);break;case "keyEnabled":this.options[a]=c;c||this!==b.dlePlayerVideo.focus||(b.dlePlayerVideo.focus=
null);break;case "keyBindings":this.options[a]=b.extend(!0,{},this.options[a],c);break;case "audioFullScreen":this.options[a]=c;break;case "autoBlur":this.options[a]=c}return this},_refreshSize:function(){this._setSize();this._addUiClass();this._updateSize();this._updateButtons();this._updateAutohide();this._trigger(b.dlePlayerVideo.event.resize)},_setSize:function(){this.options.fullWindow?(this.status.width=this.options.sizeFull.width,this.status.height=this.options.sizeFull.height,this.status.cssClass=
this.options.sizeFull.cssClass):(this.status.width=this.options.size.width,this.status.height=this.options.size.height,this.status.cssClass=this.options.size.cssClass);this.element.css({width:this.status.width,height:this.status.height})},_addUiClass:function(){this.ancestorJq.length&&this.ancestorJq.addClass(this.status.cssClass)},_removeUiClass:function(){this.ancestorJq.length&&this.ancestorJq.removeClass(this.status.cssClass)},_updateSize:function(){this.internal.poster.jq.css({width:this.status.width,
height:this.status.height});!this.status.waitForPlay&&this.html.active&&this.status.video||this.html.video.available&&this.html.used&&this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):!this.status.waitForPlay&&this.flash.active&&this.status.video&&this.internal.flash.jq.css({width:this.status.width,height:this.status.height})},_updateAutohide:function(){var a=this,b=function(b){var c=!1;if("undefined"!==typeof a.internal.mouse){c=a.internal.mouse.x-
b.pageX;var d=a.internal.mouse.y-b.pageY;c=0<Math.floor(c)||0<Math.floor(d)}else c=!0;a.internal.mouse={x:b.pageX,y:b.pageY};c&&a.css.jq.gui.fadeIn(a.options.autohide.fadeIn,function(){clearTimeout(a.internal.autohideId);a.internal.autohideId=setTimeout(function(){a.css.jq.gui.fadeOut(a.options.autohide.fadeOut)},a.options.autohide.hold)})};this.css.jq.gui.length&&(this.css.jq.gui.stop(!0,!0),clearTimeout(this.internal.autohideId),delete this.internal.mouse,this.element.unbind(".dlePlayerVideoAutohide"),
this.css.jq.gui.unbind(".dlePlayerVideoAutohide"),this.status.nativeVideoControls?this.css.jq.gui.hide():this.options.fullWindow&&this.options.autohide.full||!this.options.fullWindow&&this.options.autohide.restored?(this.element.bind("mousemove.dlePlayerVideo.dlePlayerVideoAutohide",b),this.css.jq.gui.bind("mousemove.dlePlayerVideo.dlePlayerVideoAutohide",b),this.css.jq.gui.hide()):this.css.jq.gui.show())},fullScreen:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.fullScreen?
this._setOption("fullScreen",!1):this._setOption("fullScreen",!0)},restoreScreen:function(){this._setOption("fullScreen",!1)},_fullscreenAddEventListeners:function(){var a=this,c=b.dlePlayerVideo.nativeFeatures.fullscreen;c.api.fullscreenEnabled&&c.event.fullscreenchange&&("function"!==typeof this.internal.fullscreenchangeHandler&&(this.internal.fullscreenchangeHandler=function(){a._fullscreenchange()}),document.addEventListener(c.event.fullscreenchange,this.internal.fullscreenchangeHandler,!1))},
_fullscreenRemoveEventListeners:function(){var a=b.dlePlayerVideo.nativeFeatures.fullscreen;this.internal.fullscreenchangeHandler&&document.removeEventListener(a.event.fullscreenchange,this.internal.fullscreenchangeHandler,!1)},_fullscreenchange:function(){this.options.fullScreen&&!b.dlePlayerVideo.nativeFeatures.fullscreen.api.fullscreenElement()&&this._setOption("fullScreen",!1)},_requestFullscreen:function(){var a=this.ancestorJq.length?this.ancestorJq[0]:this.element[0],c=b.dlePlayerVideo.nativeFeatures.fullscreen;
c.used.webkitVideo&&(a=this.htmlElement.video);c.api.fullscreenEnabled&&c.api.requestFullscreen(a)},_exitFullscreen:function(){var a=b.dlePlayerVideo.nativeFeatures.fullscreen;if(a.used.webkitVideo)var c=this.htmlElement.video;a.api.fullscreenEnabled&&a.api.exitFullscreen(c)},_html_initMedia:function(a){var c=b(this.htmlElement.media).empty();b.each(a.track||[],function(a,b){var d=document.createElement("track");d.setAttribute("kind",b.kind?b.kind:"");d.setAttribute("src",b.src?b.src:"");d.setAttribute("srclang",
b.srclang?b.srclang:"");d.setAttribute("label",b.label?b.label:"");b.def&&d.setAttribute("default",b.def);c.append(d)});this.htmlElement.media.src=this.status.src;"none"!==this.options.preload&&this._html_load();this._trigger(b.dlePlayerVideo.event.timeupdate)},_html_setFormat:function(a){var c=this;b.each(this.formats,function(b,f){if(c.html.support[f]&&a[f])return c.status.src=a[f],c.status.format[f]=!0,c.status.formatType=f,!1})},_html_setAudio:function(a){this._html_setFormat(a);this.htmlElement.media=
this.htmlElement.audio;this._html_initMedia(a)},_html_setVideo:function(a){this._html_setFormat(a);this.status.nativeVideoControls&&(this.htmlElement.video.poster=this._validString(a.poster)?a.poster:"");this.htmlElement.media=this.htmlElement.video;this._html_initMedia(a)},_html_resetMedia:function(){this.htmlElement.media&&(this.htmlElement.media.id!==this.internal.video.id||this.status.nativeVideoControls||this.internal.video.jq.css({width:"0px",height:"0px"}),this.htmlElement.media.pause())},
_html_clearMedia:function(){this.htmlElement.media&&(this.htmlElement.media.src="about:blank",this.htmlElement.media.load())},_html_load:function(){this.status.waitForLoad&&(this.status.waitForLoad=!1,this.htmlElement.media.load());clearTimeout(this.internal.htmlDlyCmdId)},_html_play:function(a){var b=this,d=this.htmlElement.media;this.androidFix.pause=!1;this._html_load();if(this.androidFix.setMedia)this.androidFix.play=!0,this.androidFix.time=a;else if(isNaN(a))d.play();else{this.internal.cmdsIgnored&&
d.play();try{if(!d.seekable||"object"===typeof d.seekable&&0<d.seekable.length)d.currentTime=a,d.play();else throw 1;}catch(f){this.internal.htmlDlyCmdId=setTimeout(function(){b.play(a)},250);return}}this._html_checkWaitForPlay()},_html_pause:function(a){var b=this,d=this.htmlElement.media;this.androidFix.play=!1;0<a?this._html_load():clearTimeout(this.internal.htmlDlyCmdId);d.pause();if(this.androidFix.setMedia)this.androidFix.pause=!0,this.androidFix.time=a;else if(!isNaN(a))try{if(!d.seekable||
"object"===typeof d.seekable&&0<d.seekable.length)d.currentTime=a;else throw 1;}catch(f){this.internal.htmlDlyCmdId=setTimeout(function(){b.pause(a)},250);return}0<a&&this._html_checkWaitForPlay()},_html_playHead:function(a){var b=this,d=this.htmlElement.media;this._html_load();try{if("object"===typeof d.seekable&&0<d.seekable.length)d.currentTime=a*d.seekable.end(d.seekable.length-1)/100;else if(0<d.duration&&!isNaN(d.duration))d.currentTime=a*d.duration/100;else throw"e";}catch(f){this.internal.htmlDlyCmdId=
setTimeout(function(){b.playHead(a)},250);return}this.status.waitForLoad||this._html_checkWaitForPlay()},_html_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,height:this.status.height})))},_html_setProperty:function(a,b){this.html.audio.available&&(this.htmlElement.audio[a]=b);this.html.video.available&&
(this.htmlElement.video[a]=b)},_aurora_setAudio:function(a){var c=this;b.each(this.formats,function(b,f){if(c.aurora.support[f]&&a[f])return c.status.src=a[f],c.status.format[f]=!0,c.status.formatType=f,!1});this.aurora.player=new AV.Player.fromURL(this.status.src);this._addAuroraEventListeners(this.aurora.player,this.aurora);"auto"===this.options.preload&&(this._aurora_load(),this.status.waitForLoad=!1)},_aurora_resetMedia:function(){this.aurora.player&&this.aurora.player.stop()},_aurora_clearMedia:function(){},
_aurora_load:function(){this.status.waitForLoad&&(this.status.waitForLoad=!1,this.aurora.player.preload())},_aurora_play:function(a){this.status.waitForLoad||isNaN(a)||this.aurora.player.seek(a);this.aurora.player.playing||this.aurora.player.play();this.status.waitForLoad=!1;this._aurora_checkWaitForPlay();this._updateButtons(!0);this._trigger(b.dlePlayerVideo.event.play)},_aurora_pause:function(a){isNaN(a)||this.aurora.player.seek(1E3*a);this.aurora.player.pause();0<a&&this._aurora_checkWaitForPlay();
this._updateButtons(!1);this._trigger(b.dlePlayerVideo.event.pause)},_aurora_playHead:function(a){0<this.aurora.player.duration&&this.aurora.player.seek(a*this.aurora.player.duration/100);this.status.waitForLoad||this._aurora_checkWaitForPlay()},_aurora_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1)},_aurora_volume:function(a){this.aurora.player.volume=100*a},_aurora_mute:function(a){a?(this.aurora.properties.lastvolume=this.aurora.player.volume,this.aurora.player.volume=
0):this.aurora.player.volume=this.aurora.properties.lastvolume;this.aurora.properties.muted=a},_flash_setAudio:function(a){var c=this;try{b.each(this.formats,function(b,f){if(c.flash.support[f]&&a[f]){switch(f){case "m4a":case "fla":c._getMovie().fl_setAudio_m4a(a[f]);break;case "mp3":c._getMovie().fl_setAudio_mp3(a[f]);break;case "rtmpa":c._getMovie().fl_setAudio_rtmp(a[f])}c.status.src=a[f];c.status.format[f]=!0;c.status.formatType=f;return!1}}),"auto"===this.options.preload&&(this._flash_load(),
this.status.waitForLoad=!1)}catch(d){this._flashError(d)}},_flash_setVideo:function(a){var c=this;try{b.each(this.formats,function(b,f){if(c.flash.support[f]&&a[f]){switch(f){case "m4v":case "flv":c._getMovie().fl_setVideo_m4v(a[f]);break;case "rtmpv":c._getMovie().fl_setVideo_rtmp(a[f])}c.status.src=a[f];c.status.format[f]=!0;c.status.formatType=f;return!1}}),"auto"===this.options.preload&&(this._flash_load(),this.status.waitForLoad=!1)}catch(d){this._flashError(d)}},_flash_resetMedia:function(){this.internal.flash.jq.css({width:"0px",
height:"0px"});this._flash_pause(NaN)},_flash_clearMedia:function(){try{this._getMovie().fl_clearMedia()}catch(a){this._flashError(a)}},_flash_load:function(){try{this._getMovie().fl_load()}catch(a){this._flashError(a)}this.status.waitForLoad=!1},_flash_play:function(a){try{this._getMovie().fl_play(a)}catch(c){this._flashError(c)}this.status.waitForLoad=!1;this._flash_checkWaitForPlay()},_flash_pause:function(a){try{this._getMovie().fl_pause(a)}catch(c){this._flashError(c)}0<a&&(this.status.waitForLoad=
!1,this._flash_checkWaitForPlay())},_flash_playHead:function(a){try{this._getMovie().fl_play_head(a)}catch(c){this._flashError(c)}this.status.waitForLoad||this._flash_checkWaitForPlay()},_flash_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&(this.internal.poster.jq.hide(),this.internal.flash.jq.css({width:this.status.width,height:this.status.height})))},_flash_volume:function(a){try{this._getMovie().fl_volume(a)}catch(c){this._flashError(c)}},
_flash_mute:function(a){try{this._getMovie().fl_mute(a)}catch(c){this._flashError(c)}},_getMovie:function(){return document[this.internal.flash.id]},_getFlashPluginVersion:function(){var a=0;if(window.ActiveXObject)try{var b=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");var d=b.GetVariable("$version");d&&(d=d.split(" ")[1].split(","),a=parseInt(d[0],10)+"."+parseInt(d[1],10))}catch(f){}else navigator.plugins&&0<navigator.mimeTypes.length&&(b=navigator.plugins["Shockwave Flash"])&&(a=navigator.plugins["Shockwave Flash"].description.replace(/.*\s(\d+\.\d+).*/,
"$1"));return 1*a},_checkForFlash:function(a){var b=!1;this._getFlashPluginVersion()>=a&&(b=!0);return b},_validString:function(a){return a&&"string"===typeof a},_limitValue:function(a,b,d){return a<b?b:a>d?d:a},_urlNotSetError:function(a){this._error({type:b.dlePlayerVideo.error.URL_NOT_SET,context:a,message:b.dlePlayerVideo.errorMsg.URL_NOT_SET,hint:b.dlePlayerVideo.errorHint.URL_NOT_SET})},_flashError:function(a){var c=this.internal.ready?"FLASH_DISABLED":"FLASH";this._error({type:b.dlePlayerVideo.error[c],
context:this.internal.flash.swf,message:b.dlePlayerVideo.errorMsg[c]+a.message,hint:b.dlePlayerVideo.errorHint[c]});this.internal.flash.jq.css({width:"1px",height:"1px"})},_error:function(a){this._trigger(b.dlePlayerVideo.event.error,a);this.options.errorAlerts&&this._alert("Error!"+(a.message?"\n"+a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_warning:function(a){this._trigger(b.dlePlayerVideo.event.warning,l,a);this.options.warningAlerts&&this._alert("Warning!"+(a.message?"\n"+
a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_alert:function(a){a="dlePlayerVideo "+this.version.script+" : id='"+this.internal.self.id+"' : "+a;this.options.consoleAlerts?window.console&&window.console.log&&window.console.log(a):alert(a)},_emulateHtmlBridge:function(){var a=this;b.each(b.dlePlayerVideo.emulateMethods.split(/\s+/g),function(b,d){a.internal.domNode[d]=function(b){a[d](b)}});b.each(b.dlePlayerVideo.event,function(c,d){var f=!0;b.each(b.dlePlayerVideo.reservedEvent.split(/\s+/g),
function(a,b){if(b===c)return f=!1});f&&a.element.bind(d+".dlePlayerVideo.dlePlayerVideoHtml",function(){a._emulateHtmlUpdate();var b=document.createEvent("Event");b.initEvent(c,!1,!0);a.internal.domNode.dispatchEvent(b)})})},_emulateHtmlUpdate:function(){var a=this;b.each(b.dlePlayerVideo.emulateStatus.split(/\s+/g),function(b,d){a.internal.domNode[d]=a.status[d]});b.each(b.dlePlayerVideo.emulateOptions.split(/\s+/g),function(b,d){a.internal.domNode[d]=a.options[d]})},_destroyHtmlBridge:function(){var a=
this;this.element.unbind(".dlePlayerVideoHtml");b.each((b.dlePlayerVideo.emulateMethods+" "+b.dlePlayerVideo.emulateStatus+" "+b.dlePlayerVideo.emulateOptions).split(/\s+/g),function(b,d){delete a.internal.domNode[d]})}};b.dlePlayerVideo.error={FLASH:"e_flash",FLASH_DISABLED:"e_flash_disabled",NO_SOLUTION:"e_no_solution",NO_SUPPORT:"e_no_support",URL:"e_url",URL_NOT_SET:"e_url_not_set",VERSION:"e_version"};b.dlePlayerVideo.errorMsg={FLASH:"dlePlayerVideo's Flash fallback is not configured correctly, or a command was issued before the dlePlayerVideo Ready event. Details: ",
FLASH_DISABLED:"dlePlayerVideo's Flash fallback has been disabled by the browser due to the CSS rules you have used. Details: ",NO_SOLUTION:"No solution can be found by dlePlayerVideo in this browser. Neither HTML nor Flash can be used.",NO_SUPPORT:"It is not possible to play any media format provided in setMedia() on this browser using your current options.",URL:"Media URL could not be loaded.",URL_NOT_SET:"Attempt to issue media playback commands, while no media url is set.",VERSION:"dlePlayerVideo "+
b.dlePlayerVideo.prototype.version.script+" needs Jplayer.swf version "+b.dlePlayerVideo.prototype.version.needFlash+" but found "};b.dlePlayerVideo.errorHint={FLASH:"Check your swfPath option and that Jplayer.swf is there.",FLASH_DISABLED:"Check that you have not display:none; the dlePlayerVideo entity or any ancestor.",NO_SOLUTION:"Review the dlePlayerVideo options: support and supplied.",NO_SUPPORT:"Video or audio formats defined in the supplied option are missing.",URL:"Check media URL is valid.",
URL_NOT_SET:"Use setMedia() to set the media URL.",VERSION:"Update dlePlayerVideo files."};b.dlePlayerVideo.warning={CSS_SELECTOR_COUNT:"e_css_selector_count",CSS_SELECTOR_METHOD:"e_css_selector_method",CSS_SELECTOR_STRING:"e_css_selector_string",OPTION_KEY:"e_option_key"};b.dlePlayerVideo.warningMsg={CSS_SELECTOR_COUNT:"The number of css selectors found did not equal one: ",CSS_SELECTOR_METHOD:"The methodName given in dlePlayerVideo('cssSelector') is not a valid dlePlayerVideo method.",CSS_SELECTOR_STRING:"The methodCssSelector given in dlePlayerVideo('cssSelector') is not a String or is empty.",
OPTION_KEY:"The option requested in dlePlayerVideo('option') is undefined."};b.dlePlayerVideo.warningHint={CSS_SELECTOR_COUNT:"Check your css selector and the ancestor.",CSS_SELECTOR_METHOD:"Check your method name.",CSS_SELECTOR_STRING:"Check your css selector is a string.",OPTION_KEY:"Check your option name."}});
(function(b,l){dlePlayerVideoPlaylist=function(g,h,k){var e=this;this.current=0;this.removing=this.shuffled=this.loop=!1;this.cssSelector=b.extend({},this._cssSelector,g);this.options=b.extend(!0,{keyBindings:{next:{key:221,fn:function(){e.next()}},previous:{key:219,fn:function(){e.previous()}},shuffle:{key:83,fn:function(){e.shuffle()}}},stateClass:{shuffled:"mdtc-clnplrv-state-shuffled"}},this._options,k);this.playlist=[];this.original=[];this._initPlaylist(h);this.cssSelector.details=this.cssSelector.cssSelectorAncestor+
" .mdtc-clnplrv-details";this.cssSelector.playlist=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-playlist";this.cssSelector.next=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-next";this.cssSelector.previous=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-previous";this.cssSelector.shuffle=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-shuffle";this.cssSelector.shuffleOff=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-shuffle-off";this.options.cssSelectorAncestor=this.cssSelector.cssSelectorAncestor;
this.options.repeat=function(a){e.loop=a.dlePlayerVideo.options.loop};b(this.cssSelector.dlePlayerVideo).bind(b.dlePlayerVideo.event.ready,function(){e._init()});b(this.cssSelector.dlePlayerVideo).bind(b.dlePlayerVideo.event.ended,function(){e.next()});b(this.cssSelector.dlePlayerVideo).bind(b.dlePlayerVideo.event.play,function(){b(this).dlePlayerVideo("pauseOthers")});b(this.cssSelector.dlePlayerVideo).bind(b.dlePlayerVideo.event.resize,function(a){a.dlePlayerVideo.options.fullScreen?b(e.cssSelector.details).show():
b(e.cssSelector.details).hide()});b(this.cssSelector.previous).click(function(a){a.preventDefault();e.previous();e.blur(this)});b(this.cssSelector.next).click(function(a){a.preventDefault();e.next();e.blur(this)});b(this.cssSelector.shuffle).click(function(a){a.preventDefault();e.shuffled&&b(e.cssSelector.dlePlayerVideo).dlePlayerVideo("option","useStateClassSkin")?e.shuffle(!1):e.shuffle(!0);e.blur(this)});b(this.cssSelector.shuffleOff).click(function(a){a.preventDefault();e.shuffle(!1);e.blur(this)}).hide();
this.options.fullScreen||b(this.cssSelector.details).hide();b(this.cssSelector.playlist+" ul").empty();this._createItemHandlers();b(this.cssSelector.dlePlayerVideo).dlePlayerVideo(this.options)};dlePlayerVideoPlaylist.prototype={_cssSelector:{dlePlayerVideo:"#jquery_jplayer_1",cssSelectorAncestor:"#jp_video_container_1"},_options:{playlistOptions:{autoPlay:!1,loopOnPrevious:!1,shuffleOnLoop:!0,enableRemoveControls:!1,displayTime:"slow",addTime:"fast",removeTime:"fast",shuffleTime:"slow",itemClass:"mdtc-clnplrv-playlist-item",
freeGroupClass:"mdtc-clnplrv-free-media",freeItemClass:"mdtc-clnplrv-playlist-item-free",removeItemClass:"mdtc-clnplrv-playlist-item-remove"}},option:function(b,h){if(h===l)return this.options.playlistOptions[b];this.options.playlistOptions[b]=h;switch(b){case "enableRemoveControls":this._updateControls();break;case "itemClass":case "freeGroupClass":case "freeItemClass":case "removeItemClass":this._refresh(!0),this._createItemHandlers()}return this},_init:function(){var b=this;this._refresh(function(){b.options.playlistOptions.autoPlay?
b.play(b.current):b.select(b.current)})},_initPlaylist:function(g){this.current=0;this.removing=this.shuffled=!1;this.original=b.extend(!0,[],g);this._originalPlaylist()},_originalPlaylist:function(){var g=this;this.playlist=[];b.each(this.original,function(b){g.playlist[b]=g.original[b]})},_refresh:function(g){var h=this;if(g&&!b.isFunction(g))b(this.cssSelector.playlist+" ul").empty(),b.each(this.playlist,function(e){b(h.cssSelector.playlist+" ul").append(h._createListItem(h.playlist[e]))}),this._updateControls();
else{var k=b(this.cssSelector.playlist+" ul").children().length?this.options.playlistOptions.displayTime:0;b(this.cssSelector.playlist+" ul").slideUp(k,function(){var e=b(this);b(this).empty();b.each(h.playlist,function(a){e.append(h._createListItem(h.playlist[a]))});h._updateControls();b.isFunction(g)&&g();h.playlist.length?b(this).slideDown(h.options.playlistOptions.displayTime):b(this).show()})}},_createListItem:function(g){var h=this,k="<li><div>";k+="<a href='javascript:;' class='"+this.options.playlistOptions.removeItemClass+
"'>&times;</a>";if(g.free){var e=!0;k+="<span class='"+this.options.playlistOptions.freeGroupClass+"'>(";b.each(g,function(a,c){b.dlePlayerVideo.prototype.format[a]&&(e?e=!1:k+=" | ",k+="<a class='"+h.options.playlistOptions.freeItemClass+"' href='"+c+"' tabindex='-1'>"+a+"</a>")});k+=")</span>"}k+="<span href='javascript:;' class='"+this.options.playlistOptions.itemClass+"' tabindex='0'>"+g.title+(g.artist?" <span class='mdtc-clnplrv-artist'>by "+g.artist+"</span>":"")+"</span>";return k+="</div></li>"},
_createItemHandlers:function(){var g=this;b(this.cssSelector.playlist).off("click","span."+this.options.playlistOptions.itemClass).on("click","span."+this.options.playlistOptions.itemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();g.current!==h?g.play(h):b(g.cssSelector.dlePlayerVideo).dlePlayerVideo("play");g.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.freeItemClass).on("click","a."+this.options.playlistOptions.freeItemClass,function(h){h.preventDefault();
b(this).parent().parent().find("."+g.options.playlistOptions.itemClass).click();g.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.removeItemClass).on("click","a."+this.options.playlistOptions.removeItemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();g.remove(h);g.blur(this)})},_updateControls:function(){this.options.playlistOptions.enableRemoveControls?b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).show():
b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).hide();this.shuffled?b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("addStateClass","shuffled"):b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("removeStateClass","shuffled");b(this.cssSelector.shuffle).length&&b(this.cssSelector.shuffleOff).length&&(this.shuffled?(b(this.cssSelector.shuffleOff).show(),b(this.cssSelector.shuffle).hide()):(b(this.cssSelector.shuffleOff).hide(),b(this.cssSelector.shuffle).show()))},
_highlight:function(g){this.playlist.length&&g!==l&&(b(this.cssSelector.playlist+" .mdtc-clnplrv-playlist-current").removeClass("mdtc-clnplrv-playlist-current"),b(this.cssSelector.playlist+" li:nth-child("+(g+1)+")").addClass("mdtc-clnplrv-playlist-current").find(".mdtc-clnplrv-playlist-item").addClass("mdtc-clnplrv-playlist-current"))},setPlaylist:function(b){this._initPlaylist(b);this._init()},add:function(g,h){b(this.cssSelector.playlist+" ul").append(this._createListItem(g)).find("li:last-child").hide().slideDown(this.options.playlistOptions.addTime);
this._updateControls();this.original.push(g);this.playlist.push(g);h?this.play(this.playlist.length-1):1===this.original.length&&this.select(0)},remove:function(g){var h=this;if(g===l)return this._initPlaylist([]),this._refresh(function(){b(h.cssSelector.dlePlayerVideo).dlePlayerVideo("clearMedia")}),!0;if(this.removing)return!1;g=0>g?h.original.length+g:g;0<=g&&g<this.playlist.length&&(this.removing=!0,b(this.cssSelector.playlist+" li:nth-child("+(g+1)+")").slideUp(this.options.playlistOptions.removeTime,
function(){b(this).remove();if(h.shuffled){var k=h.playlist[g];b.each(h.original,function(b){if(h.original[b]===k)return h.original.splice(b,1),!1})}else h.original.splice(g,1);h.playlist.splice(g,1);h.original.length?g===h.current?(h.current=g<h.original.length?h.current:h.original.length-1,h.select(h.current)):g<h.current&&h.current--:(b(h.cssSelector.dlePlayerVideo).dlePlayerVideo("clearMedia"),h.current=0,h.shuffled=!1,h._updateControls());h.removing=!1}));return!0},select:function(g){g=0>g?this.original.length+
g:g;0<=g&&g<this.playlist.length?(this.current=g,this._highlight(g),b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("setMedia",this.playlist[this.current])):this.current=0},play:function(g){g=0>g?this.original.length+g:g;0<=g&&g<this.playlist.length?this.playlist.length&&(this.select(g),b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("play")):g===l&&b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("play")},pause:function(){b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("pause")},next:function(){var b=
this.current+1<this.playlist.length?this.current+1:0;this.loop?0===b&&this.shuffled&&this.options.playlistOptions.shuffleOnLoop&&1<this.playlist.length?this.shuffle(!0,!0):this.play(b):0<b&&this.play(b)},previous:function(){var b=0<=this.current-1?this.current-1:this.playlist.length-1;(this.loop&&this.options.playlistOptions.loopOnPrevious||b<this.playlist.length-1)&&this.play(b)},shuffle:function(g,h){var k=this;g===l&&(g=!this.shuffled);(g||g!==this.shuffled)&&b(this.cssSelector.playlist+" ul").slideUp(this.options.playlistOptions.shuffleTime,
function(){(k.shuffled=g)?k.playlist.sort(function(){return.5-Math.random()}):k._originalPlaylist();k._refresh(!0);h||!b(k.cssSelector.dlePlayerVideo).data("dlePlayerVideo").status.paused?k.play(0):k.select(0);b(this).slideDown(k.options.playlistOptions.shuffleTime)})},blur:function(g){b(this.cssSelector.dlePlayerVideo).dlePlayerVideo("option","autoBlur")&&b(g).blur()}}})(jQuery);
(function(b){function l(b){function k(){var e=b.next(),a=e.find(".mdtc-clnplrv-song-title-inner");e=e.find(".mdtc-clnplrv-song-title").width();var c=a.width()-e;0<c&&(a.animate({marginLeft:"-="+(c-10)},2500),setTimeout(function(){a.animate({marginLeft:"+="+(c-10)},2500)},4E3))}k();setInterval(function(){k()},8E3)}function g(){for(var b="",k=0;15>k;k++)b+="abcdefghijklmnopqrstuvwxyz0123456789".charAt(Math.floor(36*Math.random()));return b}b.fn.cleanaudioplayer=function(h){(function(k,e,a,c){b("body").on("mousemove",
".mdtc-clnplrv-volume-bar",function(d){e&&e[a](b.extend({},d,{currentTarget:c}))}).on("mouseup",function(){e=!1}).on("mousedown",function(d){var f=b(d.target).parents().add(d.currentTarget);d=f.filter(".mdtc-clnplrv-volume-bar").first();f=f.filter(".mdtc-clnplrv-seek-bar").first();f.length?(a="seekBar",c=f):d.length&&(a="volumeBar",c=d);e=(d=c&&c.closest(".mdtc-clnplrv-audio"))&&d.children().first().add(d.prev()).filter(function(){return b(this).data("dlePlayerVideo")}).first().data("dlePlayerVideo")})})();
return this.each(function(k){var e=b.extend({theme:"default",supplied:"mp3,m4a,oga,wav",disableControls:!1,autoplay:!1,playlistHeight:!1,rssUrl:!1,playlist:!1},h);k=!1;var a="";if(0<b(this).find("> ul").length){var c=b(this).find("> ul");c.data("theme")?e.theme=c.data("theme"):void 0;c.data("supplied")?e.supplied=c.data("supplied"):void 0;c.data("disable-controls")?e.disableControls=c.data("disable-controls"):void 0;c.data("autoplay")?e.autoplay=c.data("autoplay"):void 0;c.data("playlist-height")?
e.playlistHeight=c.data("playlist-height"):void 0;c.data("preload")?e.preload=c.data("preload"):void 0;if(0<b(this).find("> ul li").length){var d=[];b(this).find("> ul li").each(function(){var a=b(this),c=a.data("free")?!0:!1,e=a.data("type");c={title:a.data("title"),artist:a.data("artist"),free:c};c[e]=a.data("url");d.push(c)});1==b(this).find("> ul li").length&&b(this).find("> ul li").data("free")&&(k=!0,a=b(this).find("> ul li").data("url"));e.playlist=d}}c=g();b(this).html('<div class="mdtc-clnplrv-audio mdtc-clnplrv-main-player"><div class="mdtc-clnplrv-jplayer">\x3c!-- --\x3e</div><div class="mdtc-clnplrv-type-playlist"><div class="mdtc-clnplrv-gui mdtc-clnplrv-interface"><ul class="mdtc-clnplrv-controls"><li><a href="javascript:;" class="mdtc-clnplrv-previous mdtc-clnplrv-icon-prev" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-play mdtc-clnplrv-icon-play" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-pause mdtc-clnplrv-icon-pause" tabindex="1" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-next mdtc-clnplrv-icon-next" tabindex="1"></a></li></ul><div class="mdtc-clnplrv-seek-container"><div class="mdtc-clnplrv-seek-container-inner"><div class="mdtc-clnplrv-time"><div class="mdtc-clnplrv-current-time">00:00</div><div class="mdtc-clnplrv-duration" style="display:none">00:00</div></div><div class="mdtc-clnplrv-song-title"><div class="mdtc-clnplrv-song-title-inner"><strong id="current-song">\x3c!-- --\x3e</strong></div></div><div class="mdtc-clnplrv-progress"><div class="mdtc-clnplrv-seek-bar" style="width:0%"><div class="mdtc-clnplrv-play-bar" style="width:0%">\x3c!-- --\x3e</div></div></div></div></div><div class="mdtc-clnplrv-volume-bar"><div class="mdtc-clnplrv-volume-bar-value"><i>\x3c!-- --\x3e</i></div></div><ul class="mdtc-clnplrv-toggles"><li><a title="Repeat" tabindex="1" class="mdtc-clnplrv-repeat mdtc-clnplrv-icon-repeat" href="javascript:;"></a></li><li><a title="Repeat off" tabindex="1" class="mdtc-clnplrv-repeat-off mdtc-clnplrv-icon-repeat" href="javascript:;" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle-off mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle off" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-download-one mdtc-clnplrv-icon-download" tabindex="1" title="Download" style="display:none"></a></li></ul></div><div class="mdtc-clnplrv-playlist"><ul></ul></div><div class="mdtc-clnplrv-no-solution" style="display:none"><span>Update Required </span>To play the media you will need to either update your browser to a recent version</div></div></div>');
b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-cleanaudioplayer-id-"+c);k&&(b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-solo-download"),b(this).find(".mdtc-clnplrv-download-one").attr("href",a));"dark"==e.theme&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-dark-theme");e.disableControls&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-disabled-controls");e.playlistHeight&&b(this).find(".mdtc-clnplrv-playlist > ul").css({maxHeight:e.playlistHeight,
overflowY:"auto"});1<e.playlist.length?(playerOptions={solution:"html",supplied:e.supplied,preload:e.preload,wmode:"window",ready:function(a){function c(){d.next().is(":visible")&&(450>d.parent().width()?d.parent().addClass("mdtc-clnplrv-responsive"):d.parent().removeClass("mdtc-clnplrv-responsive"))}var d=b(this);d.next().find(".mdtc-clnplrv-time").on("click",function(){d.next().find(".mdtc-clnplrv-current-time, .mdtc-clnplrv-duration").toggle()});e.autoplay&&b(this).dlePlayerVideo("play");b(window).on("resize",
function(){c()});c();setInterval(function(){c()},250);l(d)},play:function(a){b(this).dlePlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},playlistOptions:{shuffleTime:150}},new dlePlayerVideoPlaylist({dlePlayerVideo:".mdtc-clnplrv-cleanaudioplayer-id-"+c+" .mdtc-clnplrv-jplayer",cssSelectorAncestor:".mdtc-clnplrv-cleanaudioplayer-id-"+c},e.playlist,playerOptions)):b(".mdtc-clnplrv-cleanaudioplayer-id-"+c+" .mdtc-clnplrv-jplayer").dlePlayerVideo({ready:function(a){function c(){d.next().is(":visible")&&
(450>d.parent().width()?d.parent().addClass("mdtc-clnplrv-responsive"):d.parent().removeClass("mdtc-clnplrv-responsive"))}b(this).dlePlayerVideo("setMedia",e.playlist[0]);var d=b(this);d.next().find(".mdtc-clnplrv-time").on("click",function(){d.next().find(".mdtc-clnplrv-current-time, .mdtc-clnplrv-duration").toggle()});e.autoplay&&b(this).dlePlayerVideo("play");b(this).parent().addClass("mdtc-clnplrv-disabled-controls mdtc-clnplrv-solo-player");b(window).on("resize",function(){c()});c();setInterval(function(){c()},
250);l(d)},play:function(a){b(this).dlePlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},cssSelectorAncestor:".mdtc-clnplrv-cleanaudioplayer-id-"+c,supplied:e.supplied})})}})(jQuery);
(function(b){function l(b){function e(){var a=b.next(),c=a.find(".mdtc-clnplrv-song-title-inner");a=a.find(".mdtc-clnplrv-song-title").width();var d=c.width()-a;0<d&&(c.animate({marginLeft:"-="+(d-10)},2500),setTimeout(function(){c.animate({marginLeft:"+="+(d-10)},2500)},4E3))}e();setInterval(function(){e()},8E3)}function g(){for(var b="",e=0;15>e;e++)b+="abcdefghijklmnopqrstuvwxyz0123456789".charAt(Math.floor(36*Math.random()));return b}b.fn.cleanvideoplayer=function(k){(function(e,a,c,d){b("body").on("mousemove",
".mdtc-clnplrv-volume-bar",function(f){a&&a[c](b.extend({},f,{currentTarget:d}))}).on("mouseup",function(){a=!1}).on("mousedown",function(f){var e=b(f.target).parents().add(f.currentTarget);f=e.filter(".mdtc-clnplrv-volume-bar").first();e=e.filter(".mdtc-clnplrv-seek-bar").first();e.length?(c="seekBar",d=e):f.length&&(c="volumeBar",d=f);a=(f=d&&d.closest(".mdtc-clnplrv-video"))&&f.children().first().add(f.prev()).filter(function(){return b(this).data("dlePlayerVideo")}).first().data("dlePlayerVideo")})})();
return this.each(function(e){var a=b.extend({theme:"default",supplied:"m4v,webmv,youtube",disableControls:!1,autoplay:!1,playlistHeight:"290px",playlist:!1},k);e=!1;var c="";if(0<b(this).find("> ul").length){var d=b(this).find("> ul");d.data("theme")?a.theme=d.data("theme"):void 0;d.data("supplied")?a.supplied=d.data("supplied"):void 0;d.data("disable-controls")?a.disableControls=d.data("disable-controls"):void 0;d.data("autoplay")?a.autoplay=d.data("autoplay"):void 0;d.data("playlist-height")?a.playlistHeight=
d.data("playlist-height"):void 0;d.data("preload")?a.preload=d.data("preload"):void 0;if(0<b(this).find("> ul li").length){var f=[];b(this).find("> ul li").each(function(){var a=b(this),d=a.data("free")?!0:!1,c=a.data("type");d={title:a.data("title"),artist:a.data("artist"),free:d,poster:a.data("poster")};d[c]=a.data("url");f.push(d)});1==b(this).find("> ul li").length&&b(this).find("> ul li").data("free")&&(e=!0,c=b(this).find("> ul li").data("url"));a.playlist=f}}d=g();b(this).html('<div class="mdtc-clnplrv-video mdtc-clnplrv-main-player"><div class="mdtc-clnplrv-jplayer mdtc-clnplrv-video-container">\x3c!-- --\x3e</div><div class="mdtc-clnplrv-type-playlist"><div class="mdtc-clnplrv-gui mdtc-clnplrv-interface"><ul class="mdtc-clnplrv-controls"><li><a href="javascript:;" class="mdtc-clnplrv-previous mdtc-clnplrv-icon-prev" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-play mdtc-clnplrv-icon-play" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-pause mdtc-clnplrv-icon-pause" tabindex="1" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-next mdtc-clnplrv-icon-next" tabindex="1"></a></li></ul><div class="mdtc-clnplrv-seek-container"><div class="mdtc-clnplrv-seek-container-inner"><div class="mdtc-clnplrv-song-title"><div class="mdtc-clnplrv-song-title-inner"><strong id="current-song">\x3c!-- --\x3e</strong></div></div><div class="mdtc-clnplrv-progress"><div class="mdtc-clnplrv-seek-bar" style="width:0%"><div class="mdtc-clnplrv-play-bar" style="width:0%">\x3c!-- --\x3e</div></div></div><div class="mdtc-clnplrv-time"><div class="mdtc-clnplrv-current-time">00:00</div><div class="mdtc-clnplrv-duration">00:00</div></div></div></div><div class="mdtc-clnplrv-volume-bar"><div class="mdtc-clnplrv-volume-bar-value"><i>\x3c!-- --\x3e</i></div></div><ul class="mdtc-clnplrv-toggles"><li><a title="Repeat" tabindex="1" class="mdtc-clnplrv-repeat mdtc-clnplrv-icon-repeat" href="javascript:;"></a></li><li><a title="Repeat off" tabindex="1" class="mdtc-clnplrv-repeat-off mdtc-clnplrv-icon-repeat" href="javascript:;" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle-off mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle off" style="display:none"></a></li><li class="mdtc-clnplrv-fullscreen-li"><a href="javascript:;" class="mdtc-clnplrv-fullscreen-btn mdtc-clnplrv-icon-fullscreen" tabindex="1" title="Toggle fullscreen"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-download-one mdtc-clnplrv-icon-download" tabindex="1" title="Download" style="display:none"></a></li></ul></div><div class="mdtc-clnplrv-playlist"><ul></ul></div><div class="mdtc-clnplrv-no-solution" style="display:none"><span>Update Required </span>To play the media you will need to either update your browser to a recent version</div></div></div>');
b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-cleanvideoplayer-id-"+d);e&&(b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-solo-download"),b(this).find(".mdtc-clnplrv-download-one").attr("href",c));"dark"==a.theme&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-dark-theme");a.disableControls&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-disabled-controls");a.playlistHeight&&b(this).find(".mdtc-clnplrv-playlist > ul").css({maxHeight:a.playlistHeight,
overflowY:"auto"});1<a.playlist.length?(playerOptions={solution:"html",supplied:a.supplied,preload:a.preload,wmode:"window",ready:function(d){function c(){if(e.next().is(":visible")){var a=e.width(),b=a/16*9;e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.css("cssText","height:100% !important"):e.css("cssText","height:"+b+"px !important");450>a?e.parent().addClass("mdtc-clnplrv-responsive"):e.parent().removeClass("mdtc-clnplrv-responsive")}}var e=b(this);a.autoplay&&e.dlePlayerVideo("play");
e.on("click",function(){e.data().dlePlayerVideo.status.paused?e.dlePlayerVideo("play"):e.dlePlayerVideo("pause")});e.on("dblclick",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.dlePlayerVideo("restoreScreen"):e.dlePlayerVideo("fullScreen")});e.next().find(".mdtc-clnplrv-fullscreen-btn").on("click",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.dlePlayerVideo("restoreScreen"):e.dlePlayerVideo("fullScreen")});"metadata"==a.preload&&e.find("video").css("cssText",
"background: transparent");b(window).on("resize",function(){c()});c();setInterval(function(){c()},250);l(e)},play:function(a){b(this).dlePlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},playlistOptions:{shuffleTime:150},size:{width:"100%",height:"100%"}},new dlePlayerVideoPlaylist({dlePlayerVideo:".mdtc-clnplrv-cleanvideoplayer-id-"+d+" .mdtc-clnplrv-jplayer",cssSelectorAncestor:".mdtc-clnplrv-cleanvideoplayer-id-"+d},a.playlist,playerOptions)):b(".mdtc-clnplrv-cleanvideoplayer-id-"+
d+" .mdtc-clnplrv-jplayer").dlePlayerVideo({ready:function(d){function c(){if(e.next().is(":visible")){var a=e.width(),b=a/16*9;e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.css("cssText","height:100% !important"):e.css("cssText","height:"+b+"px !important");450>a?e.parent().addClass("mdtc-clnplrv-responsive"):e.parent().removeClass("mdtc-clnplrv-responsive")}}b(this).dlePlayerVideo("setMedia",a.playlist[0]);var e=b(this);a.autoplay&&b(this).dlePlayerVideo("play");e.on("click",function(){e.data().dlePlayerVideo.status.paused?
e.dlePlayerVideo("play"):e.dlePlayerVideo("pause")});e.on("dblclick",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.dlePlayerVideo("restoreScreen"):e.dlePlayerVideo("fullScreen")});e.next().find(".mdtc-clnplrv-fullscreen-btn").on("click",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.dlePlayerVideo("restoreScreen"):e.dlePlayerVideo("fullScreen")});b(this).parent().addClass("mdtc-clnplrv-disabled-controls mdtc-clnplrv-solo-player");b(window).on("resize",function(){c()});
c();setInterval(function(){c()},250);l(e)},play:function(a){b(this).dlePlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},cssSelectorAncestor:".mdtc-clnplrv-cleanvideoplayer-id-"+d,supplied:a.supplied,preload:a.preload,size:{width:"100%",height:"100%"}})})};var h={api:"https://www.youtube.com/iframe_api",load:function(b){var e=document.getElementsByTagName("head").item(0),a=[],c,d;return function(f){if(d)return a?a.push(f):f();if(b.YT&&b.YT.Player)return f();b.onYouTubeIframeAPIReady&&
a.push(b.onYouTubeIframeAPIReady);b.onYouTubeIframeAPIReady=function(){for(;0!==a.length;)try{a.shift()()}catch(m){}a=!1};d=a.push(f);c=document.createElement("script");c.src=h.api;e.appendChild(c)}}((0,eval)("this")),player:function(g,e){var a=b(g),c=g.id+"_youtube",d=function(){return a.data.apply(a,[c].concat([].slice.call(arguments)))},f=d()||d({player:!1,queue:!1})&&d();if(f.player)return e(f.player);if(f.queue)return f.queue.push(e);f.queue=[e];h.load(function(){f.container=g.parentNode.insertBefore(document.createElement("div"),
g);f.container.id=c;var d=b.dlePlayerVideo.platform.ipad||b.dlePlayerVideo.platform.iphone||b.dlePlayerVideo.platform.ipod?1:0;f.player=new YT.Player(c,{height:a.outerHeight(),width:a.outerWidth(),playerVars:{autoplay:0,controls:d,rel:0,iv_load_policy:3,showinfo:0},events:{onReady:function(){for(;0!==f.queue.length;)try{f.queue.shift()(f.player)}catch(n){}delete f.queue;b(window).on("resize",function(){f.player.setSize(a.outerWidth(),a.outerHeight())})},onStateChange:function(b){b="unstarted;ended;playing;paused;buffering;video cued".split(";")[b.data+
1];var c=g.getJPlayer(),d=function(a){c._getHtmlStatus(e,a);c._updateInterface();a&&d()};clearInterval(f.interval);if("ended"===b)g.emulateEvent("ended");else if("paused"===b)g.emulateEvent("pause");else if("playing"===b){g.emulateEvent("play");g.emulateEvent("playing");var e={currentTime:f.player.getCurrentTime(),duration:f.player.getDuration(),videoWidth:a.outerWidth(),videoHeight:a.outerHeight(),ended:!1,readyState:4,load:function(){},seekable:{length:1,end:function(){return e.duration}}};d(!0);
f.interval=setInterval(function(){e.currentTime=f.player.getCurrentTime();e.ended=e.currentTime>=e.duration;d()},1E3);f._html_playHead||(f._html_playHead=c._html_playHead);c._html_playHead=function(){var a=this.htmlElement.media,b=f.player.getCurrentTime();if(a.getVideoId()){e.currentTime=b;this.htmlElement.media=e;var c=f._html_playHead.apply(this,arguments);this.htmlElement.media=a;e.currentTime!==b&&(f.player.seekTo(e.currentTime),d())}else c=f._html_playHead.apply(this,arguments);return c}}}}})})},
hooks:{video:{getVideoId:function(){return function(){var g=b(this);return(String(g.attr("src")||g.data("src")).match(/(?:youtube\.com\/.*?[?&]v=|youtube:\/{2})([^&]+)/i)||[])[1]}},getJPlayer:function(){return function(){var g=this;do{var e=b.data(g,"dlePlayerVideo");g=g.parentNode}while(g&&!e);return e}},emulateEvent:function(){return function(b){if("function"===typeof this.dispatchEvent){var e=document.createEvent("HTMLEvents");e.initEvent(b,!0,!0,window,0,0,0,0,0,!1,!1,!1,!1,0,this);this.dispatchEvent(e)}else"undefined"!==
typeof this.fireEvent&&this.fireEvent("on"+b)}},youtube:function(){return function(b){return h.player(this,b)}},toggleVideo:function(){return function(g){this.getJPlayer().element.toggleClass("youtube-player",g).find('video,img[id*="poster"]').css(g?{position:"absolute",visibility:"visible",top:"1px"}:{position:"",visibility:"",opacity:"",top:""}).end().find("iframe").toggle(g);var e=b.dlePlayerVideo.platform.ipad||b.dlePlayerVideo.platform.iphone||b.dlePlayerVideo.platform.ipod;g&&e?this.getJPlayer().element.parent().find(".mdtc-clnplrv-interface").toggle(!1):
this.getJPlayer().element.parent().find(".mdtc-clnplrv-interface").toggle(!0)}},addEventListener:function(g){return function(e,a,c){var d=this,f=b(this);return g.call(this,e,function(b){var c=a.apply(this,arguments);d.getVideoId()&&(f.attr("src")&&/(?:abort|emptied|loadstart)/i.test(e)?f.data("src",d.src).attr("src",""):/volumechange/i.test(e)?d.youtube(function(a){a.setVolume(100*d.getJPlayer().options.volume)}):/error/i.test(e)&&(d.getJPlayer().status.waitForLoad=!1));return c},c)}},canPlayType:function(b){return function(e){return/youtube/i.test(e)?
"probably":b.apply(this,arguments)}},pause:function(b){return function(){var e=this;return this.getVideoId()?this.youtube(function(a){e.emulateEvent("pause");a.pauseVideo()}):b.apply(this,arguments)}},play:function(g){return function(){var e=this;if(this.getVideoId())return this.youtube(function(a){e.toggleVideo(!0);a.playVideo()});b(e).data("src")&&this.youtube(function(a){a.stopVideo()});this.toggleVideo(!1);return g.apply(this,arguments)}},load:function(b){return function(){var e=this,a=this.getVideoId();
if(a)return this.youtube(function(b){e.toggleVideo(!0);b.cueVideoById(a)});this.toggleVideo(!1);return b.apply(this,arguments)}}}},initialize:function(){var g=function(b,a){var c=h.hooks[a]||{},d;for(d in c)c.hasOwnProperty(d)&&(b[d]=c[d].call(b,b[d]));return b};b.dlePlayerVideo.prototype.format.youtube={flashCanPlay:!1,codec:'video/youtube; codecs="m4v"',media:"video"};"undefined"!==typeof HTMLVideoElement?g(HTMLVideoElement.prototype,"video"):document.createElement=function(b){return function(a){return g(b.apply(this,
arguments),String(a).toLowerCase())}}(document.createElement)}};h.initialize()})(jQuery);


jQuery(function($){
	$('.dleaudioplayer').cleanaudioplayer();$('.dlevideoplayer').cleanvideoplayer();
});